/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRuleConfig;

public class HiveRexShuttleTransformRule
extends RelRule<Config> {
    private HiveRexShuttleTransformRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode rewriteNode;
        RelNode startNode = call.rel(0);
        if (startNode != (rewriteNode = startNode.accept(((Config)this.config).shuttleFactory.apply(startNode.getCluster().getRexBuilder())))) {
            call.transformTo(rewriteNode);
        }
    }

    public static class Config
    extends HiveRuleConfig {
        private Function<RexBuilder, RexShuttle> shuttleFactory;

        public Config withRexShuttle(Function<RexBuilder, RexShuttle> shuttleFactory) {
            this.shuttleFactory = Objects.requireNonNull(shuttleFactory);
            return this;
        }

        public HiveRexShuttleTransformRule toRule() {
            return new HiveRexShuttleTransformRule(this);
        }
    }
}

