/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;

public class HiveOptimizeInlineArrayTableFunctionRule
extends RelOptRule {
    public static final HiveOptimizeInlineArrayTableFunctionRule INSTANCE = new HiveOptimizeInlineArrayTableFunctionRule(HiveRelFactories.HIVE_BUILDER);

    public HiveOptimizeInlineArrayTableFunctionRule(RelBuilderFactory relBuilderFactory) {
        super(HiveOptimizeInlineArrayTableFunctionRule.operand(HiveTableFunctionScan.class, (RelOptRuleOperandChildren)HiveOptimizeInlineArrayTableFunctionRule.any()), relBuilderFactory, null);
    }

    public boolean matches(RelOptRuleCall call) {
        HiveTableFunctionScan tableFunctionScanRel = (HiveTableFunctionScan)call.rel(0);
        if (!(tableFunctionScanRel.getCall() instanceof RexCall)) {
            return false;
        }
        RexCall udtfCall = (RexCall)tableFunctionScanRel.getCall();
        if (udtfCall.getOperator() != SqlStdOperatorTable.LATERAL) {
            return false;
        }
        RexCall inlineCall = (RexCall)udtfCall.getOperands().get(0);
        if (!"inline".equalsIgnoreCase(inlineCall.getOperator().getName())) {
            return false;
        }
        Preconditions.checkState((!inlineCall.getOperands().isEmpty() ? 1 : 0) != 0);
        RexNode operand = (RexNode)inlineCall.getOperands().get(0);
        if (!(operand instanceof RexCall)) {
            return false;
        }
        RexCall firstOperand = (RexCall)operand;
        if (!"array".equalsIgnoreCase(firstOperand.getOperator().getName())) {
            return false;
        }
        Preconditions.checkState((!firstOperand.getOperands().isEmpty() ? 1 : 0) != 0);
        int numStructParams = ((RexNode)firstOperand.getOperands().get(0)).getType().getFieldCount();
        return tableFunctionScanRel.getRowType().getFieldCount() != numStructParams;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveTableFunctionScan tfs = (HiveTableFunctionScan)call.rel(0);
        RelNode inputRel = tfs.getInput(0);
        RexCall lateralCall = (RexCall)tfs.getCall();
        RexCall inlineCall = (RexCall)lateralCall.getOperands().get(0);
        RexCall arrayCall = (RexCall)inlineCall.getOperands().get(0);
        RelOptCluster cluster = tfs.getCluster();
        List inputRefs = Lists.transform((List)inputRel.getRowType().getFieldList(), input -> new RexInputRef(input.getIndex(), input.getType()));
        ArrayList<RexNode> newStructExprs = new ArrayList<RexNode>();
        for (RexNode currentStructOperand : arrayCall.getOperands()) {
            ArrayList allOperands = new ArrayList(inputRefs);
            RexCall structCall = (RexCall)currentStructOperand;
            allOperands.addAll(structCall.getOperands());
            newStructExprs.add(cluster.getRexBuilder().makeCall(structCall.op, allOperands));
        }
        ArrayList returnTypes = new ArrayList(Lists.transform((List)inputRel.getRowType().getFieldList(), RelDataTypeField::getType));
        RexCall firstStructCall = (RexCall)arrayCall.getOperands().get(0);
        returnTypes.addAll(Lists.transform((List)firstStructCall.getOperands(), RexNode::getType));
        List<RexNode> newArrayCall = Collections.singletonList(cluster.getRexBuilder().makeCall(arrayCall.op, newStructExprs));
        RexNode newInlineCall = cluster.getRexBuilder().makeCall(tfs.getRowType(), inlineCall.op, newArrayCall);
        TableFunctionScan newTableFunctionScanNode = tfs.copy(tfs.getTraitSet(), tfs.getInputs(), newInlineCall, tfs.getElementType(), tfs.getRowType(), Collections.emptySet());
        call.transformTo((RelNode)newTableFunctionScanNode);
    }
}

