/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.protobuf;

import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;

public abstract class ProtobufSerDe
extends AbstractSerDe {
    static final String PROTO_CLASS = "proto.class";
    static final String MAP_TYPES = "proto.maptypes";
    protected Class<? extends Message> protoMessageClass;
    private ProtoToHiveConvertor convertor;
    private ObjectInspector objectInspector;
    private Set<String> mapTypes;

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.mapTypes = Sets.newHashSet((Object[])this.properties.getProperty(MAP_TYPES, "").trim().split("\\s*,\\s*"));
        this.protoMessageClass = this.loadClass(this.properties.getProperty(PROTO_CLASS));
        Descriptors.Descriptor descriptor = ProtobufSerDe.loadDescriptor(this.protoMessageClass);
        HashMap<Descriptors.Descriptor, ObjectInspector> cache = new HashMap<Descriptors.Descriptor, ObjectInspector>();
        this.objectInspector = this.createStructObjectInspector(descriptor, cache);
        HashMap<Descriptors.Descriptor, ProtoToHiveConvertor> convertorCache = new HashMap<Descriptors.Descriptor, ProtoToHiveConvertor>();
        this.convertor = this.createConvertor(descriptor, convertorCache);
    }

    private Class<? extends Message> loadClass(String protoClass) throws SerDeException {
        if (protoClass == null) {
            throw new SerDeException("proto.class has to be set.");
        }
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(protoClass);
            if (!Message.class.isAssignableFrom(clazz)) {
                throw new SerDeException("Invalid class: " + clazz.getName() + " is not type of: " + Message.class.getName());
            }
            Class<?> serdeClass = clazz;
            return serdeClass;
        }
        catch (ClassNotFoundException e) {
            throw new SerDeException("Cannot find/load class: " + protoClass, (Throwable)e);
        }
    }

    private static Descriptors.Descriptor loadDescriptor(Class<? extends Message> protoClass) throws SerDeException {
        try {
            Method method = protoClass.getMethod("getDescriptor", null);
            return (Descriptors.Descriptor)method.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SerDeException("Error trying to get descriptor for class: " + protoClass.getName(), (Throwable)e);
        }
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException("Not implemented serialize");
    }

    public Object deserialize(Writable blob) throws SerDeException {
        if (blob == null) {
            return null;
        }
        Message message = this.toMessage(blob);
        if (message == null) {
            return null;
        }
        return this.convertor.convert(message);
    }

    protected abstract Message toMessage(Writable var1) throws SerDeException;

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    private ObjectInspector createStructObjectInspector(Descriptors.Descriptor descriptor, Map<Descriptors.Descriptor, ObjectInspector> cache) throws SerDeException {
        if (cache.containsKey(descriptor)) {
            return cache.get(descriptor);
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ObjectInspector> columnOI = new ArrayList<ObjectInspector>();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            columnNames.add(field.getName());
            columnOI.add(this.createObjectInspector(field, cache));
        }
        StandardStructObjectInspector oi = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, columnOI);
        cache.put(descriptor, (ObjectInspector)oi);
        return oi;
    }

    private ObjectInspector createObjectInspector(Descriptors.FieldDescriptor descriptor, Map<Descriptors.Descriptor, ObjectInspector> cache) throws SerDeException {
        ObjectInspector oi;
        switch (descriptor.getJavaType()) {
            case BOOLEAN: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN);
                break;
            }
            case BYTE_STRING: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.BINARY);
                break;
            }
            case DOUBLE: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
                break;
            }
            case ENUM: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.STRING);
                break;
            }
            case FLOAT: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
                break;
            }
            case INT: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.INT);
                break;
            }
            case LONG: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.LONG);
                break;
            }
            case STRING: {
                oi = ProtobufSerDe.getPrimitive(PrimitiveObjectInspector.PrimitiveCategory.STRING);
                break;
            }
            case MESSAGE: {
                Descriptors.Descriptor msgType = descriptor.getMessageType();
                if (descriptor.isRepeated() && this.mapTypes.contains(msgType.getFullName())) {
                    return this.getMapObjectInspector(msgType, cache);
                }
                oi = this.createStructObjectInspector(msgType, cache);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type: " + String.valueOf(descriptor.getJavaType()));
            }
        }
        return descriptor.isRepeated() ? ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)oi) : oi;
    }

    private ObjectInspector getMapObjectInspector(Descriptors.Descriptor descriptor, Map<Descriptors.Descriptor, ObjectInspector> cache) throws SerDeException {
        List fields = descriptor.getFields();
        if (fields.size() != 2) {
            throw new SerDeException("Map type " + descriptor.getFullName() + " should have only 2 fields, got: " + fields.size());
        }
        ObjectInspector keyOI = this.createObjectInspector((Descriptors.FieldDescriptor)fields.get(0), cache);
        ObjectInspector valueOI = this.createObjectInspector((Descriptors.FieldDescriptor)fields.get(1), cache);
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyOI, (ObjectInspector)valueOI);
    }

    private static ObjectInspector getPrimitive(PrimitiveObjectInspector.PrimitiveCategory cat) {
        return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)cat);
    }

    private ProtoToHiveConvertor createConvertor(Descriptors.Descriptor descriptor, Map<Descriptors.Descriptor, ProtoToHiveConvertor> cache) throws SerDeException {
        if (cache.containsKey(descriptor)) {
            return cache.get(descriptor);
        }
        List fields = descriptor.getFields();
        StructConvertor scConvertor = new StructConvertor(fields.size());
        int i = 0;
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            ProtoToHiveConvertor fc = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? this.createConvertor(field.getMessageType(), cache) : (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.BYTE_STRING ? ByteStringConvertor.INSTANCE : (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM ? EnumConvertor.INSTANCE : IdentityConvertor.INSTANCE));
            if (field.isRepeated()) {
                if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && this.mapTypes.contains(field.getMessageType().getFullName())) {
                    if (field.getMessageType().getFields().size() != 2) {
                        throw new SerDeException("Expected exactly 2 fields for: " + field.getMessageType().getFullName());
                    }
                    fc = new MapConvertor(fc);
                } else {
                    fc = new ListConvertor(fc);
                }
            }
            scConvertor.add(i++, field, fc);
        }
        cache.put(descriptor, scConvertor);
        return scConvertor;
    }

    private static interface ProtoToHiveConvertor {
        default public Object extractAndConvert(Descriptors.FieldDescriptor field, Message msg) {
            Object val = msg.hasField(field) ? msg.getField(field) : null;
            return val == null ? null : this.convert(val);
        }

        public Object convert(Object var1);
    }

    private static class StructConvertor
    implements ProtoToHiveConvertor {
        private final Descriptors.FieldDescriptor[] fields;
        private final ProtoToHiveConvertor[] convertors;

        StructConvertor(int size) {
            this.fields = new Descriptors.FieldDescriptor[size];
            this.convertors = new ProtoToHiveConvertor[size];
        }

        void add(int i, Descriptors.FieldDescriptor field, ProtoToHiveConvertor convertor) {
            this.fields[i] = field;
            this.convertors[i] = convertor;
        }

        @Override
        public Object convert(Object obj) {
            Message msg = (Message)obj;
            Object[] ret = new Object[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                ret[i] = this.convertors[i].extractAndConvert(this.fields[i], msg);
            }
            return ret;
        }
    }

    private static class ByteStringConvertor
    implements ProtoToHiveConvertor {
        private static final ProtoToHiveConvertor INSTANCE = new ByteStringConvertor();

        private ByteStringConvertor() {
        }

        @Override
        public Object convert(Object obj) {
            return ((ByteString)obj).toByteArray();
        }
    }

    private static class EnumConvertor
    implements ProtoToHiveConvertor {
        private static final ProtoToHiveConvertor INSTANCE = new EnumConvertor();

        private EnumConvertor() {
        }

        @Override
        public Object convert(Object obj) {
            return ((Descriptors.EnumValueDescriptor)obj).getName();
        }
    }

    private static class IdentityConvertor
    implements ProtoToHiveConvertor {
        private static final ProtoToHiveConvertor INSTANCE = new IdentityConvertor();

        private IdentityConvertor() {
        }

        @Override
        public Object convert(Object obj) {
            return obj;
        }
    }

    private static class MapConvertor
    implements ProtoToHiveConvertor {
        private final ProtoToHiveConvertor convertor;

        MapConvertor(ProtoToHiveConvertor convertor) {
            this.convertor = convertor;
        }

        @Override
        public Object extractAndConvert(Descriptors.FieldDescriptor field, Message msg) {
            int count = msg.getRepeatedFieldCount(field);
            if (count == 0) {
                return null;
            }
            HashMap<Object, Object> val = new HashMap<Object, Object>(count);
            for (int j = 0; j < count; ++j) {
                Object[] entry = (Object[])this.convertor.convert(msg.getRepeatedField(field, j));
                val.put(entry[0], entry[1]);
            }
            return val;
        }

        @Override
        public Object convert(Object obj) {
            throw new UnsupportedOperationException("Use extractAndConvert for MapConvertor");
        }
    }

    private static class ListConvertor
    implements ProtoToHiveConvertor {
        private final ProtoToHiveConvertor convertor;

        ListConvertor(ProtoToHiveConvertor convertor) {
            this.convertor = convertor;
        }

        @Override
        public Object extractAndConvert(Descriptors.FieldDescriptor field, Message msg) {
            int count = msg.getRepeatedFieldCount(field);
            if (count == 0) {
                return null;
            }
            Object[] val = new Object[count];
            for (int j = 0; j < count; ++j) {
                val[j] = this.convertor.convert(msg.getRepeatedField(field, j));
            }
            return val;
        }

        @Override
        public Object convert(Object obj) {
            throw new UnsupportedOperationException("Use extractAndConvert for ListConvertor");
        }
    }
}

