/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetTableUtils;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordWriterWrapper
implements RecordWriter<NullWritable, ParquetHiveRecord>,
StatsProvidingRecordWriter,
FileSinkOperator.RecordWriter {
    public static final Logger LOG = LoggerFactory.getLogger(ParquetRecordWriterWrapper.class);
    private final org.apache.hadoop.mapreduce.RecordWriter<NullWritable, ParquetHiveRecord> realWriter;
    private final TaskAttemptContext taskContext;
    private final JobConf jobConf;
    private final Path file;
    private SerDeStats stats;

    public ParquetRecordWriterWrapper(OutputFormat<Void, ParquetHiveRecord> realOutputFormat, JobConf jobConf, String name, Progressable progress, Properties tableProperties) throws IOException {
        try {
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)jobConf.get("mapred.task.id"));
            if (taskAttemptID == null) {
                taskAttemptID = new TaskAttemptID();
            }
            this.taskContext = ContextUtil.newTaskAttemptContext((Configuration)jobConf, (TaskAttemptID)taskAttemptID);
            LOG.info("initialize serde with table properties.");
            this.initializeSerProperties((JobContext)this.taskContext, tableProperties);
            LOG.info("creating real writer to write at " + name);
            this.jobConf = jobConf;
            this.file = new Path(name);
            this.realWriter = ((ParquetOutputFormat)realOutputFormat).getRecordWriter(this.taskContext, this.file);
            LOG.info("real writer: " + String.valueOf(this.realWriter));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public ParquetRecordWriterWrapper(ParquetOutputFormat<ParquetHiveRecord> realOutputFormat, JobConf jobConf, String name, Progressable progress) throws IOException {
        this((OutputFormat<Void, ParquetHiveRecord>)realOutputFormat, jobConf, name, progress, ParquetRecordWriterWrapper.getParquetProperties(jobConf));
    }

    private static Properties getParquetProperties(JobConf jobConf) {
        Properties tblProperties = new Properties();
        for (Map.Entry entry : jobConf) {
            if (!ParquetTableUtils.isParquetProperty((String)entry.getKey())) continue;
            tblProperties.put(entry.getKey(), entry.getValue());
        }
        return tblProperties;
    }

    private void initializeSerProperties(JobContext job, Properties tableProperties) {
        String compressionName;
        String enableDictionaryPage;
        String blockSize = tableProperties.getProperty("parquet.block.size");
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        if (blockSize != null && !blockSize.isEmpty()) {
            LOG.debug("get override parquet.block.size property via tblproperties");
            conf.setInt("parquet.block.size", Integer.parseInt(blockSize));
        }
        if ((enableDictionaryPage = tableProperties.getProperty("parquet.enable.dictionary")) != null && !enableDictionaryPage.isEmpty()) {
            LOG.debug("get override parquet.enable.dictionary property via tblproperties");
            conf.setBoolean("parquet.enable.dictionary", Boolean.parseBoolean(enableDictionaryPage));
        }
        if ((compressionName = tableProperties.getProperty("parquet.compression")) != null && !compressionName.isEmpty()) {
            LOG.debug("get override compression properties via tblproperties");
            CompressionCodecName codecName = CompressionCodecName.fromConf((String)compressionName);
            conf.set("parquet.compression", codecName.name());
        }
    }

    public void close(Reporter reporter) throws IOException {
        try {
            this.realWriter.close(this.taskContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)this.file, (Configuration)this.jobConf));){
            long totalSize = 0L;
            for (BlockMetaData block : reader.getFooter().getBlocks()) {
                totalSize += block.getTotalByteSize();
            }
            this.stats = new SerDeStats();
            this.stats.setRowCount(reader.getRecordCount());
            this.stats.setRawDataSize(totalSize);
        }
        catch (IOException e) {
            LOG.info("Unable to collect file stats from the parquet file {} due to: {}", (Object)this.file, (Object)e.getMessage());
        }
    }

    public void write(NullWritable key, ParquetHiveRecord value) throws IOException {
        try {
            this.realWriter.write((Object)key, (Object)value);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close(boolean abort) throws IOException {
        this.close(null);
    }

    @Override
    public void write(Writable w) throws IOException {
        this.write(null, (ParquetHiveRecord)w);
    }

    @Override
    public SerDeStats getStats() {
        return this.stats;
    }
}

