/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.orc.FileFormatException;
import org.apache.orc.tools.FileDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostExecOrcFileDump
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)PostExecOrcFileDump.class.getName());
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    @Override
    public void run(HookContext hookContext) throws Exception {
        assert (hookContext.getHookType() == HookContext.HookType.POST_EXEC_HOOK);
        HiveConf conf = hookContext.getConf();
        LOG.info("Executing post execution hook to print orc file dump..");
        QueryPlan plan = hookContext.getQueryPlan();
        if (plan == null) {
            return;
        }
        FetchTask fetchTask = plan.getFetchTask();
        if (fetchTask != null) {
            ArrayList directories;
            SessionState ss = SessionState.get();
            SessionState.LogHelper console = ss.getConsole();
            PrintStream old = System.out;
            System.setOut(console.getErrStream());
            FetchWork fetchWork = (FetchWork)fetchTask.getWork();
            boolean partitionedTable = fetchWork.isPartitioned();
            if (partitionedTable) {
                LOG.info("Printing orc file dump for files from partitioned directory..");
                directories = Lists.newArrayList(fetchWork.getPartDir());
            } else {
                LOG.info("Printing orc file dump for files from table directory..");
                directories = Lists.newArrayList((Object[])new Path[]{fetchWork.getTblDir()});
            }
            Collections.sort(directories);
            for (Path dir : directories) {
                this.printFileStatus(console, dir.getFileSystem((Configuration)conf), dir);
            }
            System.out.flush();
            System.setOut(old);
        }
    }

    private void printFileStatus(SessionState.LogHelper console, FileSystem fs, Path dir) throws Exception {
        List<FileStatus> fileList = Arrays.asList(fs.listStatus(dir, hiddenFileFilter));
        Collections.sort(fileList);
        for (FileStatus fileStatus : fileList) {
            if (fileStatus.isDirectory()) {
                this.printFileStatus(console, fs, fileStatus.getPath());
                continue;
            }
            LOG.info("Printing orc file dump for " + String.valueOf(fileStatus.getPath()));
            if (fileStatus.getLen() > 0L) {
                try {
                    Reader notUsed = OrcFile.createReader(fs, fileStatus.getPath());
                    if (notUsed != null) {
                        notUsed.close();
                    }
                    console.printError("-- BEGIN ORC FILE DUMP --");
                    FileDump.main((String[])new String[]{fileStatus.getPath().toString(), "--rowindex=*"});
                    console.printError("-- END ORC FILE DUMP --");
                }
                catch (FileFormatException e) {
                    LOG.warn("File " + String.valueOf(fileStatus.getPath()) + " is not ORC. Skip printing orc file dump");
                }
                catch (IOException e) {
                    LOG.warn("Skip printing orc file dump. Exception: " + e.getMessage());
                }
                continue;
            }
            LOG.warn("Zero length file encountered. Skip printing orc file dump.");
        }
    }
}

