/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorCount
extends VectorPTFEvaluatorBase {
    protected long count;

    public VectorPTFEvaluatorCount(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        ColumnVector colVector = batch.cols[this.inputColumnNum];
        if (colVector.isRepeating) {
            if (colVector.noNulls || !colVector.isNull[0]) {
                this.count += (long)size;
            }
        } else if (colVector.noNulls) {
            this.count += (long)size;
        } else {
            boolean[] batchIsNull = colVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            long varCount = 1L;
            ++i;
            while (i < size) {
                if (!batchIsNull[i]) {
                    ++varCount;
                }
                ++i;
            }
            this.count += varCount;
        }
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    @Override
    public boolean isGroupResultNull() {
        return false;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public Object getGroupResult() {
        return this.count;
    }

    @Override
    public void resetEvaluator() {
        this.count = 0L;
    }
}

