/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashSetStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableContainerBase;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastStringHashSetContainer
extends VectorMapJoinFastHashTableContainerBase
implements VectorMapJoinBytesHashSet {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastStringHashSetContainer.class);
    private final VectorMapJoinFastStringHashSet[] vectorMapJoinFastStringHashSets;
    private final BinarySortableDeserializeRead keyBinarySortableDeserializeRead;
    private final int numThreads;

    public VectorMapJoinFastStringHashSetContainer(boolean isFullOuter, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, TableDesc tableDesc, int numHTs) {
        this.vectorMapJoinFastStringHashSets = new VectorMapJoinFastStringHashSet[numHTs];
        LOG.info("Initializing {} HT Containers ", (Object)numHTs);
        for (int i = 0; i < numHTs; ++i) {
            this.vectorMapJoinFastStringHashSets[i] = new VectorMapJoinFastStringHashSet(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount, tableDesc);
        }
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[]{TypeInfoFactory.stringTypeInfo};
        this.keyBinarySortableDeserializeRead = BinarySortableDeserializeRead.with((TypeInfo[])primitiveTypeInfos, (boolean)false, (Properties)tableDesc.getProperties());
        this.numThreads = numHTs;
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        this.vectorMapJoinFastStringHashSets[(int)((long)(this.numThreads - 1) & hashCode)].putRow(hashCode, currentKey, currentValue);
    }

    @Override
    public long getHashCode(BytesWritable currentKey) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        try {
            if (!this.keyBinarySortableDeserializeRead.readNextField()) {
                return 0L;
            }
        }
        catch (Exception e) {
            throw new HiveException("DeserializeRead details: " + this.keyBinarySortableDeserializeRead.getDetailedReadPositionString(), (Throwable)e);
        }
        return HashCodeUtil.murmurHash((byte[])this.keyBinarySortableDeserializeRead.currentBytes, (int)this.keyBinarySortableDeserializeRead.currentBytesStart, (int)this.keyBinarySortableDeserializeRead.currentBytesLength);
    }

    @Override
    public long getEstimatedMemorySize() {
        long estimatedMemorySize = 0L;
        for (int i = 0; i < this.numThreads; ++i) {
            estimatedMemorySize += this.vectorMapJoinFastStringHashSets[i].getEstimatedMemorySize();
        }
        return estimatedMemorySize;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            size += this.vectorMapJoinFastStringHashSets[i].size();
        }
        return size;
    }

    @Override
    public MatchTracker createMatchTracker() {
        int count = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            count += this.vectorMapJoinFastStringHashSets[i].logicalHashBucketCount;
        }
        return MatchTracker.create(count);
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int spillPartitionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashSetResult hashSetResult) throws IOException {
        long hashCode = HashCodeUtil.murmurHash((byte[])keyBytes, (int)keyStart, (int)keyLength);
        return this.vectorMapJoinFastStringHashSets[(int)((long)(this.numThreads - 1) & hashCode)].contains(keyBytes, keyStart, keyLength, hashSetResult);
    }

    @Override
    public VectorMapJoinHashSetResult createHashSetResult() {
        return new VectorMapJoinFastBytesHashSetStore.HashSetResult();
    }
}

