/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastValueStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;

public class VectorMapJoinFastLongHashMap
extends VectorMapJoinFastLongHashTable
implements VectorMapJoinLongHashMap,
MemoryEstimate {
    protected VectorMapJoinFastValueStore valueStore;
    private BytesWritable testValueBytesWritable;
    private long fullOuterNullKeyValueRef;

    @Override
    public VectorMapJoinHashMapResult createHashMapResult() {
        return new VectorMapJoinFastValueStore.HashMapResult();
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        return new NonMatchedLongHashMapIterator(matchTracker, this);
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        if (!this.adaptPutRow(hashCode, currentKey, currentValue) && this.isFullOuter) {
            this.addFullOuterNullKeyValue(currentValue);
        }
    }

    @Override
    public boolean containsLongKey(long currentKey) {
        return this.containsKey(currentKey);
    }

    @VisibleForTesting
    public void testPutRow(long currentKey, byte[] currentValue) throws HiveException, IOException {
        if (this.testValueBytesWritable == null) {
            this.testValueBytesWritable = new BytesWritable();
        }
        this.testValueBytesWritable.set(currentValue, 0, currentValue.length);
        long hashCode = HashCodeUtil.calculateLongHashCode((long)currentKey);
        this.add(hashCode, currentKey, this.testValueBytesWritable);
    }

    @Override
    public void assignSlot(int slot, long key, boolean isNewKey, BytesWritable currentValue) {
        byte[] valueBytes = currentValue.getBytes();
        int valueLength = currentValue.getLength();
        int pairIndex = 2 * slot;
        if (isNewKey) {
            this.slotPairs[pairIndex] = this.valueStore.addFirst(valueBytes, 0, valueLength);
            this.slotPairs[pairIndex + 1] = key;
        } else {
            this.slotPairs[pairIndex] = this.valueStore.addMore(this.slotPairs[pairIndex], valueBytes, 0, valueLength);
        }
    }

    @Override
    public JoinUtil.JoinResult lookup(long key, VectorMapJoinHashMapResult hashMapResult) {
        JoinUtil.JoinResult joinResult;
        VectorMapJoinFastValueStore.HashMapResult optimizedHashMapResult = (VectorMapJoinFastValueStore.HashMapResult)hashMapResult;
        optimizedHashMapResult.forget();
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        int pairIndex = this.findReadSlot(key, hashCode);
        if (pairIndex == -1) {
            joinResult = JoinUtil.JoinResult.NOMATCH;
        } else {
            optimizedHashMapResult.set(this.valueStore, this.slotPairs[pairIndex]);
            joinResult = JoinUtil.JoinResult.MATCH;
        }
        optimizedHashMapResult.setJoinResult(joinResult);
        return joinResult;
    }

    @Override
    public JoinUtil.JoinResult lookup(long key, VectorMapJoinHashMapResult hashMapResult, MatchTracker matchTracker) {
        JoinUtil.JoinResult joinResult;
        VectorMapJoinFastValueStore.HashMapResult optimizedHashMapResult = (VectorMapJoinFastValueStore.HashMapResult)hashMapResult;
        optimizedHashMapResult.forget();
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        int pairIndex = this.findReadSlot(key, hashCode);
        if (pairIndex == -1) {
            joinResult = JoinUtil.JoinResult.NOMATCH;
        } else {
            if (matchTracker != null) {
                matchTracker.trackMatch(pairIndex / 2);
            }
            optimizedHashMapResult.set(this.valueStore, this.slotPairs[pairIndex]);
            joinResult = JoinUtil.JoinResult.MATCH;
        }
        optimizedHashMapResult.setJoinResult(joinResult);
        return joinResult;
    }

    public void addFullOuterNullKeyValue(BytesWritable currentValue) {
        byte[] valueBytes = currentValue.getBytes();
        int valueLength = currentValue.getLength();
        this.fullOuterNullKeyValueRef = this.fullOuterNullKeyValueRef == 0L ? this.valueStore.addFirst(valueBytes, 0, valueLength) : this.valueStore.addMore(this.fullOuterNullKeyValueRef, valueBytes, 0, valueLength);
    }

    public VectorMapJoinFastLongHashMap(boolean isFullOuter, boolean minMaxEnabled, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, TableDesc tableDesc) {
        super(isFullOuter, minMaxEnabled, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount, tableDesc);
        this.valueStore = new VectorMapJoinFastValueStore(writeBuffersSize);
        this.fullOuterNullKeyValueRef = 0L;
    }

    @Override
    public long getEstimatedMemorySize() {
        return super.getEstimatedMemorySize() + this.valueStore.getEstimatedMemorySize();
    }

    public static class NonMatchedLongHashMapIterator
    extends VectorMapJoinFastNonMatchedIterator {
        private VectorMapJoinFastLongHashMap hashMap;
        private boolean noMore;
        private boolean keyIsNull;
        private WriteBuffers.Position nonMatchedReadPos;
        private WriteBuffers.ByteSegmentRef nonMatchedKeyByteSegmentRef;
        private VectorMapJoinFastValueStore.HashMapResult nonMatchedHashMapResult;

        public NonMatchedLongHashMapIterator(MatchTracker matchTracker, VectorMapJoinFastLongHashMap hashMap) {
            super(matchTracker);
            this.hashMap = hashMap;
        }

        @Override
        public void init() {
            super.init();
            this.noMore = false;
            this.keyIsNull = false;
            this.nonMatchedHashMapResult = new VectorMapJoinFastValueStore.HashMapResult();
        }

        @Override
        public boolean findNextNonMatched() {
            block3: {
                int nonMatchedDoubleIndex;
                if (this.noMore) {
                    return false;
                }
                do {
                    ++this.nonMatchedLogicalSlotNum;
                    if (this.nonMatchedLogicalSlotNum >= this.hashMap.logicalHashBucketCount) break block3;
                } while (this.hashMap.slotPairs[nonMatchedDoubleIndex = this.nonMatchedLogicalSlotNum * 2] == 0L || this.matchTracker.wasMatched(this.nonMatchedLogicalSlotNum));
                this.nonMatchedHashMapResult.set(this.hashMap.valueStore, this.hashMap.slotPairs[nonMatchedDoubleIndex]);
                this.keyIsNull = false;
                return true;
            }
            if (this.hashMap.fullOuterNullKeyValueRef == 0L) {
                return false;
            }
            this.nonMatchedHashMapResult.set(this.hashMap.valueStore, this.hashMap.fullOuterNullKeyValueRef);
            this.noMore = true;
            this.keyIsNull = true;
            return true;
        }

        @Override
        public boolean readNonMatchedLongKey() {
            return !this.keyIsNull;
        }

        @Override
        public long getNonMatchedLongKey() {
            return this.hashMap.slotPairs[this.nonMatchedLogicalSlotNum * 2 + 1];
        }

        @Override
        public VectorMapJoinHashMapResult getNonMatchedHashMapResult() {
            return this.nonMatchedHashMapResult;
        }
    }
}

