/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class CastStringToIntervalYearMonth
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public CastStringToIntervalYearMonth() {
    }

    public CastStringToIntervalYearMonth(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.evaluate(outputColVector, inputColVector, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.evaluate(outputColVector, inputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluate(outputColVector, inputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.evaluate(outputColVector, inputColVector, i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputColVector.isNull[i]) {
                    outputIsNull[i] = false;
                    this.evaluate(outputColVector, inputColVector, i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            System.arraycopy(inputColVector.isNull, 0, outputColVector.isNull, 0, n);
            for (int i = 0; i != n; ++i) {
                if (!inputColVector.isNull[i]) {
                    outputIsNull[i] = false;
                    this.evaluate(outputColVector, inputColVector, i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    private void evaluate(LongColumnVector outputColVector, BytesColumnVector inputColVector, int i) {
        try {
            HiveIntervalYearMonth interval = HiveIntervalYearMonth.valueOf((String)new String(inputColVector.vector[i], inputColVector.start[i], inputColVector.length[i], "UTF-8"));
            outputColVector.vector[i] = interval.getTotalMonths();
        }
        catch (Exception e) {
            outputColVector.vector[i] = 1L;
            outputColVector.isNull[i] = true;
            outputColVector.noNulls = false;
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

