/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.hive.ql.exec.tez.WmTezSession;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManager;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.apache.hadoop.hive.ql.wm.TriggerActionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillMoveTriggerActionHandler
implements TriggerActionHandler<WmTezSession> {
    private static final Logger LOG = LoggerFactory.getLogger(KillMoveTriggerActionHandler.class);
    private final WorkloadManager wm;

    KillMoveTriggerActionHandler(WorkloadManager wm) {
        this.wm = wm;
    }

    @Override
    public void applyAction(Map<WmTezSession, Trigger> queriesViolated) {
        Future future;
        WmTezSession wmTezSession;
        HashMap<WmTezSession, Future<Boolean>> moveFutures = new HashMap<WmTezSession, Future<Boolean>>();
        HashMap<WmTezSession, Future<Boolean>> killFutures = new HashMap<WmTezSession, Future<Boolean>>();
        block8: for (Map.Entry<WmTezSession, Trigger> entry : queriesViolated.entrySet()) {
            wmTezSession = entry.getKey();
            switch (entry.getValue().getAction().getType()) {
                case KILL_QUERY: {
                    Future<Boolean> killFuture = this.wm.applyKillSessionAsync(wmTezSession, entry.getValue().getViolationMsg());
                    killFutures.put(wmTezSession, killFuture);
                    continue block8;
                }
                case MOVE_TO_POOL: {
                    String destPoolName = entry.getValue().getAction().getPoolName();
                    if (wmTezSession.isDelayedMove()) continue block8;
                    Future<Boolean> moveFuture = this.wm.applyMoveSessionAsync(wmTezSession, destPoolName);
                    moveFutures.put(wmTezSession, moveFuture);
                    continue block8;
                }
            }
            throw new RuntimeException("Unsupported action: " + String.valueOf(entry.getValue()));
        }
        for (Map.Entry<WmTezSession, Trigger> entry : moveFutures.entrySet()) {
            wmTezSession = entry.getKey();
            future = (Future)((Object)entry.getValue());
            try {
                if (!((Boolean)future.get()).booleanValue()) continue;
                LOG.info("Moved session {} to pool {}", (Object)wmTezSession.getSessionId(), (Object)wmTezSession.getPoolName());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Exception while moving session {}", (Object)wmTezSession.getSessionId(), (Object)e);
            }
        }
        for (Map.Entry<WmTezSession, Trigger> entry : killFutures.entrySet()) {
            wmTezSession = entry.getKey();
            future = (Future)((Object)entry.getValue());
            try {
                if (!((Boolean)future.get()).booleanValue()) continue;
                LOG.info("Killed session {}", (Object)wmTezSession.getSessionId());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Exception while killing session {}", (Object)wmTezSession.getSessionId(), (Object)e);
            }
        }
    }
}

