/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Ranger Dump Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class RangerDumpWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Path currentDumpPath;
    private String dbName;
    private final transient ReplicationMetricCollector metricCollector;

    public RangerDumpWork(Path currentDumpPath, String dbName, ReplicationMetricCollector metricCollector) {
        this.currentDumpPath = currentDumpPath;
        this.dbName = dbName;
        this.metricCollector = metricCollector;
    }

    public Path getCurrentDumpPath() {
        return this.currentDumpPath;
    }

    public String getDbName() {
        return this.dbName;
    }

    URL getRangerConfigResource() {
        return this.getClass().getClassLoader().getResource("ranger-hive-security.xml");
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }
}

