/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.KeyWrapperComparator;
import org.apache.hadoop.hive.ql.exec.KeyWrapperFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TopNKeyFilter;
import org.apache.hadoop.hive.ql.exec.vector.VectorTopNKeyOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TopNKeyDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class TopNKeyOperator
extends Operator<TopNKeyDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<KeyWrapper, TopNKeyFilter> topNKeyFilters;
    private transient KeyWrapper partitionKeyWrapper;
    private transient KeyWrapper keyWrapper;
    private transient KeyWrapperComparator keyWrapperComparator;
    private transient Set<KeyWrapper> disabledPartitions;

    public TopNKeyOperator() {
    }

    public TopNKeyOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        ObjectInspector rowInspector;
        super.initializeOp(hconf);
        this.outputObjInspector = rowInspector = this.inputObjInspectors[0];
        int numPartitionKeys = ((TopNKeyDesc)this.conf).getPartitionKeyColumns().size();
        List<ExprNodeDesc> keyColumns = ((TopNKeyDesc)this.conf).getKeyColumns().subList(numPartitionKeys, ((TopNKeyDesc)this.conf).getKeyColumns().size());
        String columnSortOrder = ((TopNKeyDesc)this.conf).getColumnSortOrder().substring(numPartitionKeys);
        String nullSortOrder = ((TopNKeyDesc)this.conf).getNullOrder().substring(numPartitionKeys);
        ObjectInspector[] keyObjectInspectors = new ObjectInspector[keyColumns.size()];
        ObjectInspector[] currentKeyObjectInspectors = new ObjectInspector[keyColumns.size()];
        this.keyWrapper = this.initObjectInspectors(hconf, keyColumns, rowInspector, keyObjectInspectors, currentKeyObjectInspectors);
        ObjectInspector[] partitionKeyObjectInspectors = new ObjectInspector[numPartitionKeys];
        ObjectInspector[] partitionCurrentKeyObjectInspectors = new ObjectInspector[numPartitionKeys];
        this.partitionKeyWrapper = this.initObjectInspectors(hconf, ((TopNKeyDesc)this.conf).getPartitionKeyColumns(), rowInspector, partitionKeyObjectInspectors, partitionCurrentKeyObjectInspectors);
        this.keyWrapperComparator = new KeyWrapperComparator(keyObjectInspectors, currentKeyObjectInspectors, columnSortOrder, nullSortOrder);
        this.topNKeyFilters = new HashMap<KeyWrapper, TopNKeyFilter>();
        this.disabledPartitions = new HashSet<KeyWrapper>();
    }

    private KeyWrapper initObjectInspectors(Configuration hconf, List<ExprNodeDesc> keyColumns, ObjectInspector rowInspector, ObjectInspector[] keyObjectInspectors, ObjectInspector[] currentKeyObjectInspectors) throws HiveException {
        ExprNodeEvaluator[] keyFields = new ExprNodeEvaluator[keyColumns.size()];
        for (int i = 0; i < keyColumns.size(); ++i) {
            ExprNodeDesc key = keyColumns.get(i);
            keyFields[i] = ExprNodeEvaluatorFactory.get(key, hconf);
            keyObjectInspectors[i] = keyFields[i].initialize(rowInspector);
            currentKeyObjectInspectors[i] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)keyObjectInspectors[i], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        KeyWrapperFactory keyWrapperFactory = new KeyWrapperFactory(keyFields, keyObjectInspectors, currentKeyObjectInspectors);
        return keyWrapperFactory.getKeyWrapper();
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (!this.disabledPartitions.isEmpty() && this.disabledPartitions.size() == this.topNKeyFilters.size()) {
            this.forward(row, this.outputObjInspector);
            return;
        }
        this.partitionKeyWrapper.getNewKey(row, this.inputObjInspectors[tag]);
        this.partitionKeyWrapper.setHashKey();
        if (this.disabledPartitions.contains(this.partitionKeyWrapper)) {
            this.forward(row, this.outputObjInspector);
            return;
        }
        TopNKeyFilter topNKeyFilter = this.topNKeyFilters.get(this.partitionKeyWrapper);
        if (topNKeyFilter == null && this.topNKeyFilters.size() < ((TopNKeyDesc)this.conf).getMaxNumberOfPartitions()) {
            topNKeyFilter = new TopNKeyFilter(((TopNKeyDesc)this.conf).getTopN(), this.keyWrapperComparator);
            this.topNKeyFilters.put(this.partitionKeyWrapper.copyKey(), topNKeyFilter);
        }
        if (topNKeyFilter == null) {
            this.forward(row, this.outputObjInspector);
        } else {
            this.keyWrapper.getNewKey(row, this.inputObjInspectors[tag]);
            this.keyWrapper.setHashKey();
            if (topNKeyFilter.canForward(this.keyWrapper)) {
                this.forward(row, this.outputObjInspector);
            }
        }
        if (this.runTimeNumRows % ((TopNKeyDesc)this.conf).getCheckEfficiencyNumRows() == 0L) {
            VectorTopNKeyOperator.checkTopNFilterEfficiency(this.topNKeyFilters, this.disabledPartitions, ((TopNKeyDesc)this.conf).getEfficiencyThreshold(), this.LOG, ((TopNKeyDesc)this.conf).getCheckEfficiencyNumRows());
        }
    }

    @Override
    protected final void closeOp(boolean abort) throws HiveException {
        if (this.topNKeyFilters.size() == 1) {
            TopNKeyFilter filter = this.topNKeyFilters.values().iterator().next();
            this.LOG.info("Closing TopNKeyFilter: {}", (Object)filter);
            filter.clear();
        } else {
            this.LOG.info("Closing {} TopNKeyFilters", (Object)this.topNKeyFilters.size());
            for (TopNKeyFilter each : this.topNKeyFilters.values()) {
                this.LOG.debug("Closing TopNKeyFilter: {}", (Object)each);
                each.clear();
            }
        }
        this.topNKeyFilters.clear();
        this.disabledPartitions.clear();
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return TopNKeyOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "TNK";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.TOPNKEY;
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean columnNamesRowResolvedCanBeObtained() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public boolean supportUnionRemoveOptimization() {
        return true;
    }
}

