/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ParsedOutputFileName {
    private static final Pattern COPY_FILE_NAME_TO_TASK_ID_REGEX = Pattern.compile("^(.*?)?(\\(.*\\))?([0-9]+)(?:_([0-9]{1,6}))?(?:_copy_([0-9]{1,6}))?(\\..*)?$");
    private final boolean matches;
    private final String taskIdPrefix;
    private final String taskId;
    private final String attemptId;
    private final String copyIndex;
    private final String suffix;
    private final CharSequence filePrefixForCopy;

    public static ParsedOutputFileName parse(String fileName) {
        return new ParsedOutputFileName(fileName);
    }

    private ParsedOutputFileName(CharSequence fileName) {
        Matcher m = COPY_FILE_NAME_TO_TASK_ID_REGEX.matcher(fileName);
        this.matches = m.matches();
        if (this.matches) {
            this.taskIdPrefix = m.group(2);
            this.taskId = m.group(3);
            this.attemptId = m.group(4);
            this.copyIndex = m.group(5);
            this.suffix = m.group(6);
            this.filePrefixForCopy = m.end(4) >= 0 ? fileName.subSequence(0, m.end(4)) : null;
        } else {
            this.taskIdPrefix = null;
            this.taskId = null;
            this.attemptId = null;
            this.copyIndex = null;
            this.suffix = null;
            this.filePrefixForCopy = null;
        }
    }

    public boolean matches() {
        return this.matches;
    }

    public String getTaskIdPrefix() {
        return this.taskIdPrefix;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getPrefixedTaskId() {
        String prefix = this.getTaskIdPrefix();
        String taskId = this.getTaskId();
        if (prefix != null && taskId != null) {
            return prefix + taskId;
        }
        return taskId;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public boolean isCopyFile() {
        return this.copyIndex != null;
    }

    public String getCopyIndex() {
        return this.copyIndex;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String makeFilenameWithCopyIndex(int idx) throws HiveException {
        if (this.filePrefixForCopy == null) {
            throw new HiveException("Not expected format for copying files.");
        }
        return String.valueOf(this.filePrefixForCopy) + "_copy_" + idx;
    }

    public String toString() {
        return "[taskId: " + this.getPrefixedTaskId() + ", taskAttemptId: " + this.getAttemptId() + ", copyIndex: " + this.getCopyIndex() + "]";
    }
}

