/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.show;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

@Explain(displayName="Show Partitions", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowPartitionsDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA = "partition#string";
    private final String tabName;
    private final String resFile;
    private final Map<String, String> partSpec;
    private final short limit;
    private final String order;
    private final ExprNodeDesc cond;

    public ShowPartitionsDesc(String tabName, Path resFile, Map<String, String> partSpec, ExprNodeDesc condition, String order, short limit) {
        this.tabName = tabName;
        this.resFile = resFile.toString();
        this.partSpec = partSpec;
        this.cond = condition;
        this.order = order;
        this.limit = limit;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTabName() {
        return this.tabName;
    }

    @Explain(displayName="partSpec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public short getLimit() {
        return this.limit;
    }

    public ExprNodeDesc getCond() {
        return this.cond;
    }

    @Explain(displayName="limit", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public int getLimitExplain() {
        return this.limit;
    }

    @Explain(displayName="order", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getOrder() {
        return this.order;
    }

    @Explain(displayName="condition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getFilterStr() {
        return this.cond.getExprString();
    }
}

