/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter.ShowTableStatusFormatter;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class TextShowTableStatusFormatter
extends ShowTableStatusFormatter {
    private static final String UNKNOWN = "unknown";

    @Override
    public void showTableStatus(DataOutputStream out, Hive db, HiveConf conf, List<Table> tables, Partition partition) throws HiveException {
        try {
            for (Table table : tables) {
                this.writeBasicInfo(out, table);
                this.writeStorageInfo(out, partition, table);
                this.writeColumnsInfo(out, table);
                this.writeFileSystemInfo(out, db, conf, partition, table);
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    private void writeBasicInfo(DataOutputStream out, Table table) throws IOException, UnsupportedEncodingException {
        out.write(("tableName:" + table.getTableName()).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(("owner:" + table.getOwner()).getBytes(StandardCharsets.UTF_8));
        out.write(10);
    }

    private void writeStorageInfo(DataOutputStream out, Partition partition, Table table) throws HiveException, IOException {
        ShowTableStatusFormatter.StorageInfo storageInfo = this.getStorageInfo(table, partition);
        out.write(("location:" + storageInfo.location).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(("inputformat:" + storageInfo.inputFormatClass).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(("outputformat:" + storageInfo.outputFormatClass).getBytes(StandardCharsets.UTF_8));
    }

    private void writeColumnsInfo(DataOutputStream out, Table table) throws IOException, UnsupportedEncodingException {
        String columns = MetaStoreUtils.getDDLFromFieldSchema((String)"columns", table.getCols());
        String partitionColumns = table.isPartitioned() ? MetaStoreUtils.getDDLFromFieldSchema((String)"partition_columns", table.getPartCols()) : "";
        out.write(10);
        out.write(("columns:" + columns).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(("partitioned:" + table.isPartitioned()).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(("partitionColumns:" + partitionColumns).getBytes(StandardCharsets.UTF_8));
        out.write(10);
    }

    private void writeFileSystemInfo(DataOutputStream out, Hive db, HiveConf conf, Partition partition, Table table) throws HiveException, IOException {
        List<Path> locations = this.getLocations(db, partition, table);
        if (!locations.isEmpty()) {
            this.writeFileSystemStats(out, conf, locations, table.getPath());
        }
        out.write(10);
    }

    private void writeFileSystemStats(DataOutputStream out, HiveConf conf, List<Path> locations, Path tablePath) throws IOException {
        ShowTableStatusFormatter.FileData fileData = this.getFileData(conf, locations, tablePath);
        out.write("totalNumberFiles:".getBytes(StandardCharsets.UTF_8));
        out.write(((String)(fileData.unknown ? UNKNOWN : "" + fileData.numOfFiles)).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        if (fileData.numOfErasureCodedFiles > 0) {
            out.write("totalNumberErasureCodedFiles:".getBytes(StandardCharsets.UTF_8));
            out.write(((String)(fileData.unknown ? UNKNOWN : "" + fileData.numOfErasureCodedFiles)).getBytes(StandardCharsets.UTF_8));
            out.write(10);
        }
        out.write("totalFileSize:".getBytes(StandardCharsets.UTF_8));
        out.write(((String)(fileData.unknown ? UNKNOWN : "" + fileData.totalFileSize)).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write("maxFileSize:".getBytes(StandardCharsets.UTF_8));
        out.write(((String)(fileData.unknown ? UNKNOWN : "" + fileData.maxFileSize)).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write("minFileSize:".getBytes(StandardCharsets.UTF_8));
        if (fileData.numOfFiles > 0) {
            out.write(((String)(fileData.unknown ? UNKNOWN : "" + fileData.minFileSize)).getBytes(StandardCharsets.UTF_8));
        } else {
            out.write((fileData.unknown ? UNKNOWN : "0").getBytes(StandardCharsets.UTF_8));
        }
        out.write(10);
        out.write("lastAccessTime:".getBytes(StandardCharsets.UTF_8));
        out.writeBytes((String)(fileData.unknown || fileData.lastAccessTime < 0L ? UNKNOWN : "" + fileData.lastAccessTime));
        out.write(10);
        out.write("lastUpdateTime:".getBytes(StandardCharsets.UTF_8));
        out.write(((String)(fileData.unknown ? UNKNOWN : "" + fileData.lastUpdateTime)).getBytes(StandardCharsets.UTF_8));
        out.write(10);
    }
}

