/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.formatter.JsonDescTableFormatter;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter.ShowTableStatusFormatter;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;

public class JsonShowTableStatusFormatter
extends ShowTableStatusFormatter {
    @Override
    public void showTableStatus(DataOutputStream out, Hive db, HiveConf conf, List<Table> tables, Partition partition) throws HiveException {
        ArrayList<Map<String, Object>> tableData = new ArrayList<Map<String, Object>>();
        try {
            for (Table table : tables) {
                tableData.add(this.makeOneTableStatus(table, db, conf, partition));
            }
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        ShowUtils.asJson(out, MapBuilder.create().put("tables", tableData).build());
    }

    private Map<String, Object> makeOneTableStatus(Table table, Hive db, HiveConf conf, Partition partition) throws HiveException, IOException {
        ShowTableStatusFormatter.StorageInfo storageInfo = this.getStorageInfo(table, partition);
        MapBuilder builder = MapBuilder.create();
        builder.put("tableName", table.getTableName());
        builder.put("ownerType", table.getOwnerType() != null ? table.getOwnerType().name() : "null");
        builder.put("owner", table.getOwner());
        builder.put("location", storageInfo.location);
        builder.put("inputFormat", storageInfo.inputFormatClass);
        builder.put("outputFormat", storageInfo.outputFormatClass);
        builder.put("columns", JsonDescTableFormatter.createColumnsInfo(table.getCols(), Collections.emptyList()));
        builder.put("partitioned", table.isPartitioned());
        if (table.isPartitioned()) {
            builder.put("partitionColumns", JsonDescTableFormatter.createColumnsInfo(table.getPartCols(), Collections.emptyList()));
        }
        if (table.getTableType() != TableType.VIRTUAL_VIEW) {
            this.putFileSystemStats(builder, this.getLocations(db, partition, table), conf, table.getPath());
        }
        return builder.build();
    }

    private void putFileSystemStats(MapBuilder builder, List<Path> locations, HiveConf conf, Path tablePath) throws IOException {
        ShowTableStatusFormatter.FileData fileData = this.getFileData(conf, locations, tablePath);
        builder.put("totalNumberFiles", fileData.numOfFiles, !fileData.unknown).put("totalFileSize", fileData.totalFileSize, !fileData.unknown).put("maxFileSize", fileData.maxFileSize, !fileData.unknown).put("minFileSize", fileData.getMinFileSize(), !fileData.unknown).put("lastAccessTime", fileData.lastAccessTime, !fileData.unknown && fileData.lastAccessTime >= 0L).put("lastUpdateTime", fileData.lastUpdateTime, !fileData.unknown);
    }
}

