/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.msck;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.Msck;
import org.apache.hadoop.hive.metastore.MsckInfo;
import org.apache.hadoop.hive.metastore.PartitionManagementTask;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetastoreException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.misc.msck.MsckDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.thrift.TException;

public class MsckOperation
extends DDLOperation<MsckDesc> {
    public MsckOperation(DDLOperationContext context, MsckDesc desc) {
        super(context, desc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute() throws HiveException, IOException, TException, MetastoreException {
        try {
            Msck msck = new Msck(false, false);
            msck.init(Msck.getMsckConf((Configuration)this.context.getDb().getConf()));
            msck.updateExpressionProxy(Msck.getProxyClass((Configuration)this.context.getDb().getConf()));
            TableName tableName = HiveTableName.of(((MsckDesc)this.desc).getTableName());
            long partitionExpirySeconds = -1L;
            try (HiveMetaStoreClient msc = new HiveMetaStoreClient((Configuration)this.context.getConf());){
                boolean msckEnablePartitionRetention = MetastoreConf.getBoolVar((Configuration)this.context.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSCK_REPAIR_ENABLE_PARTITION_RETENTION);
                if (msckEnablePartitionRetention) {
                    Table table = msc.getTable(SessionState.get().getCurrentCatalog(), tableName.getDb(), tableName.getTable());
                    String qualifiedTableName = Warehouse.getCatalogQualifiedTableName((Table)table);
                    partitionExpirySeconds = PartitionManagementTask.getRetentionPeriodInSeconds((Table)table);
                    LOG.info("{} - Retention period ({}s) for partition is enabled for MSCK REPAIR..", (Object)qualifiedTableName, (Object)partitionExpirySeconds);
                }
            }
            MsckInfo msckInfo = new MsckInfo(SessionState.get().getCurrentCatalog(), tableName.getDb(), tableName.getTable(), ((MsckDesc)this.desc).getFilterExp(), ((MsckDesc)this.desc).getResFile(), ((MsckDesc)this.desc).isRepairPartitions(), ((MsckDesc)this.desc).isAddPartitions(), ((MsckDesc)this.desc).isDropPartitions(), partitionExpirySeconds);
            int result = msck.repair(msckInfo);
            Map smallFilesStats = msckInfo.getSmallFilesStats();
            if (smallFilesStats == null) return result;
            if (smallFilesStats.isEmpty()) return result;
            List<String> logInfo = smallFilesStats.entrySet().stream().map(entry -> String.format("Average file size is too small, small files exist. %n Partition name: %s. %s", entry.getKey(), entry.getValue())).collect(Collectors.toList());
            SessionState ss = SessionState.get();
            if (ss != null) {
                if (ss.getConsole() != null) {
                    ss.getConsole().printInfo("[MSCK] Small files detected.");
                    ss.getConsole().printInfo("");
                    logInfo.forEach(line -> ss.getConsole().printInfo("[MSCK] " + line));
                    return result;
                }
            }
            LOG.info("There are small files exist.\n{}", (Object)String.join((CharSequence)"\n", logInfo));
            return result;
        }
        catch (MetaException | MetastoreException e) {
            LOG.error("Unable to create msck instance.", e);
            throw e;
        }
        catch (SemanticException e) {
            LOG.error("Msck failed.", (Throwable)e);
            return 1;
        }
    }
}

