/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Compiler;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.DriverTxnHandler;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.Executor;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContext;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.HookRunner;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.cache.results.CacheUsage;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lock.CompileLock;
import org.apache.hadoop.hive.ql.lock.CompileLockFactory;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.queryhistory.QueryHistoryService;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements IDriver {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private static final String SNAPSHOT_WAS_OUTDATED_WHEN_LOCKS_WERE_ACQUIRED = "snapshot was outdated when locks were acquired";
    private int maxRows = 100;
    @VisibleForTesting
    final DriverContext driverContext;
    private final DriverState driverState = new DriverState();
    private final DriverTxnHandler driverTxnHandler;
    private Context context;
    private TaskQueue taskQueue;

    @VisibleForTesting
    public Driver(HiveConf conf) {
        this(new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(conf).build());
    }

    public Driver(HiveConf conf, Context ctx, LineageState lineageState) {
        this(QueryState.getNewQueryState(conf, lineageState), QueryInfo.getFromConf(conf));
        this.context = ctx;
    }

    public Driver(QueryState queryState) {
        this(queryState, null, null);
    }

    public Driver(QueryState queryState, QueryInfo queryInfo) {
        this(queryState, queryInfo, null);
    }

    public Driver(QueryState queryState, QueryInfo queryInfo, HiveTxnManager txnManager) {
        this.driverContext = new DriverContext(queryState, queryInfo, new HookRunner(queryState.getConf(), CONSOLE), txnManager);
        this.driverTxnHandler = new DriverTxnHandler(this.driverContext, this.driverState);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public HiveConf getConf() {
        return this.driverContext.getConf();
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        return this.run(command, false);
    }

    @Override
    public CommandProcessorResponse run() throws CommandProcessorException {
        return this.run(null, true);
    }

    private CommandProcessorResponse run(String command, boolean alreadyCompiled) throws CommandProcessorException {
        try {
            this.runInternal(command, alreadyCompiled);
            return new CommandProcessorResponse(this.getSchema(), null);
        }
        catch (CommandProcessorException cpe) {
            this.processRunException(cpe);
            this.saveErrorMessageAndRethrow(cpe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal(String command, boolean alreadyCompiled) throws CommandProcessorException {
        DriverState.setDriverState(this.driverState);
        QueryPlan plan = this.driverContext.getPlan();
        if (plan != null && plan.isPrepareQuery() && !plan.isExplain()) {
            LOG.info("Skip running tasks for prepare plan");
            return;
        }
        this.setInitialStateForRun(alreadyCompiled);
        boolean isFinishedWithError = true;
        try {
            HiveDriverRunHookContextImpl hookContext = new HiveDriverRunHookContextImpl((Configuration)this.driverContext.getConf(), alreadyCompiled ? this.context.getCmd() : command);
            this.runPreDriverHooks(hookContext);
            if (!alreadyCompiled) {
                this.compileInternal(command, true);
            } else {
                this.driverContext.getPlan().setQueryStartTime(this.driverContext.getQueryDisplay().getQueryStartTime());
            }
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "at acquiring the lock.", null, null);
            this.lockAndRespond();
            this.validateCurrentSnapshot();
            PerfLogger perfLogger = SessionState.getPerfLogger(true);
            this.context.setHiveTxnManager(this.driverContext.getTxnManager());
            this.execute();
            FetchTask fetchTask = this.driverContext.getPlan().getFetchTask();
            if (fetchTask != null) {
                fetchTask.setTaskQueue(null);
                fetchTask.setQueryPlan(null);
                try {
                    fetchTask.execute();
                    this.driverContext.setFetchTask(fetchTask);
                }
                catch (Throwable e) {
                    throw new CommandProcessorException(e);
                }
            }
            this.driverTxnHandler.handleTransactionAfterExecution();
            this.driverContext.getQueryDisplay().setPerfLogStarts(QueryDisplay.Phase.EXECUTION, perfLogger.getStartTimes());
            this.driverContext.getQueryDisplay().setPerfLogEnds(QueryDisplay.Phase.EXECUTION, perfLogger.getEndTimes());
            this.runPostDriverHooks(hookContext);
            isFinishedWithError = false;
        }
        finally {
            if (this.driverState.isAborted()) {
                this.closeInProcess(true);
            } else {
                this.releaseResources();
            }
            this.driverState.executionFinishedWithLocking(isFinishedWithError);
        }
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
    }

    private void validateCurrentSnapshot() throws CommandProcessorException {
        int retryShapshotCount = 0;
        int maxRetrySnapshotCount = HiveConf.getIntVar((Configuration)this.driverContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_MAX_RETRYSNAPSHOT_COUNT);
        try {
            do {
                this.driverContext.setOutdatedTxn(false);
                if (this.driverTxnHandler.isValidTxnListState()) continue;
                LOG.info("Re-compiling after acquiring locks, attempt #" + retryShapshotCount);
                HiveTxnManager txnMgr = this.driverContext.getTxnManager();
                if (this.driverContext.isOutdatedTxn()) {
                    LOG.info("Snapshot is outdated, re-initiating transaction ...");
                    txnMgr.rollbackTxn();
                    String userFromUGI = DriverUtils.getUserFromUGI(this.driverContext);
                    txnMgr.openTxn(this.context, userFromUGI, this.driverContext.getTxnType());
                    this.lockAndRespond();
                } else {
                    txnMgr.clearCaches();
                }
                this.driverContext.getConf().unset("hive.txn.valid.txns");
                this.driverContext.setRetrial(true);
                this.compileInternal(this.context.getCmd(), true);
                if (this.driverContext.getPlan().hasAcidResourcesInQuery()) {
                    this.driverTxnHandler.recordValidWriteIds();
                    this.driverTxnHandler.setWriteIdForAcidFileSinks();
                }
                this.driverContext.getPlan().setQueryStartTime(this.driverContext.getQueryDisplay().getQueryStartTime());
                this.driverContext.setRetrial(false);
            } while (this.driverContext.isOutdatedTxn() && ++retryShapshotCount <= maxRetrySnapshotCount);
        }
        catch (LockException | SemanticException e) {
            DriverUtils.handleHiveException(this.driverContext, (HiveException)e, 13, null);
        }
        if (retryShapshotCount > maxRetrySnapshotCount) {
            HiveException e = new HiveException("Operation could not be executed, snapshot was outdated when locks were acquired.");
            DriverUtils.handleHiveException(this.driverContext, e, 14, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setInitialStateForRun(boolean alreadyCompiled) throws CommandProcessorException {
        this.driverState.lock();
        try {
            if (alreadyCompiled) {
                if (this.driverState.isCompiled()) {
                    this.driverState.executing();
                    return;
                }
                String errorMessage = "FAILED: Precompiled query has been cancelled or closed.";
                CONSOLE.printError(errorMessage);
                throw DriverUtils.createProcessorException(this.driverContext, 12, errorMessage, null, null);
            }
            this.driverState.compiling();
            return;
        }
        finally {
            this.driverState.unlock();
        }
    }

    private void runPreDriverHooks(HiveDriverRunHookContext hookContext) throws CommandProcessorException {
        try {
            this.driverContext.getHookRunner().runPreDriverHooks(hookContext);
        }
        catch (Exception e) {
            String errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            CONSOLE.printError(errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
            throw DriverUtils.createProcessorException(this.driverContext, 12, errorMessage, ErrorMsg.findSQLState((String)e.getMessage()), e);
        }
    }

    public void lockAndRespond() throws CommandProcessorException {
        if (this.driverContext.getPlan() == null) {
            throw new IllegalStateException("No previously compiled query for driver - queryId=" + this.driverContext.getQueryState().getQueryId());
        }
        try {
            this.driverTxnHandler.acquireLocksIfNeeded();
        }
        catch (CommandProcessorException cpe) {
            this.driverTxnHandler.rollback(cpe);
            this.saveErrorMessageAndRethrow(cpe);
        }
    }

    private void execute() throws CommandProcessorException {
        try {
            this.taskQueue = new TaskQueue(this.context);
            Executor executor = new Executor(this.context, this.driverContext, this.driverState, this.taskQueue);
            executor.execute();
        }
        catch (CommandProcessorException cpe) {
            this.driverTxnHandler.rollback(cpe);
            this.saveErrorMessageAndRethrow(cpe);
        }
    }

    private void runPostDriverHooks(HiveDriverRunHookContext hookContext) throws CommandProcessorException {
        try {
            this.driverContext.getHookRunner().runPostDriverHooks(hookContext);
        }
        catch (Exception e) {
            String errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            CONSOLE.printError(errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
            throw DriverUtils.createProcessorException(this.driverContext, 12, errorMessage, ErrorMsg.findSQLState((String)e.getMessage()), e);
        }
    }

    private void processRunException(CommandProcessorException cpe) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            return;
        }
        MetaDataFormatter mdf = MetaDataFormatUtils.getFormatter(ss.getConf());
        if (!(mdf instanceof JsonMetaDataFormatter)) {
            return;
        }
        try {
            if (cpe.getCause() == null) {
                mdf.error((OutputStream)ss.out, cpe.getMessage(), cpe.getResponseCode(), cpe.getSqlState());
                return;
            }
            ErrorMsg canonicalErr = ErrorMsg.getErrorMsg((int)cpe.getResponseCode());
            if (canonicalErr != null && canonicalErr != ErrorMsg.GENERIC_ERROR) {
                mdf.error((OutputStream)ss.out, cpe.getMessage(), cpe.getResponseCode(), cpe.getSqlState(), null);
                return;
            }
            if (cpe.getCause() instanceof HiveException) {
                HiveException rc = (HiveException)cpe.getCause();
                mdf.error((OutputStream)ss.out, cpe.getMessage(), rc.getCanonicalErrorMsg().getErrorCode(), cpe.getSqlState(), rc.getCanonicalErrorMsg() == ErrorMsg.GENERIC_ERROR ? StringUtils.stringifyException((Throwable)rc) : null);
            } else {
                ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg((String)cpe.getCause().getMessage());
                mdf.error((OutputStream)ss.out, cpe.getMessage(), canonicalMsg.getErrorCode(), cpe.getSqlState(), StringUtils.stringifyException((Throwable)cpe.getCause()));
            }
        }
        catch (HiveException ex) {
            CONSOLE.printError("Unable to JSON-encode the error", StringUtils.stringifyException((Throwable)ex));
        }
    }

    @Override
    public CommandProcessorResponse compileAndRespond(String command) throws CommandProcessorException {
        return this.compileAndRespond(command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse compileAndRespond(String command, boolean cleanupTxnList) throws CommandProcessorException {
        try {
            this.compileInternal(command, false);
            CommandProcessorResponse commandProcessorResponse = new CommandProcessorResponse(this.getSchema(), null);
            return commandProcessorResponse;
        }
        catch (CommandProcessorException cpe) {
            this.saveErrorMessageAndRethrow(cpe);
            CommandProcessorResponse commandProcessorResponse = null;
            return commandProcessorResponse;
        }
        finally {
            if (cleanupTxnList) {
                this.driverTxnHandler.cleanupTxnList();
            }
        }
    }

    private void compileInternal(String command, boolean deferClose) throws CommandProcessorException {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            metrics.incrementCounter("waiting_compile_ops", 1L);
        }
        PerfLogger perfLogger = SessionState.getPerfLogger(true);
        perfLogger.perfLogBegin(CLASS_NAME, "waitCompile");
        try (CompileLock compileLock = CompileLockFactory.newInstance(this.driverContext.getConf(), command);){
            boolean success = compileLock.tryAcquire();
            perfLogger.perfLogEnd(CLASS_NAME, "waitCompile");
            if (metrics != null) {
                metrics.decrementCounter("waiting_compile_ops", 1L);
            }
            if (!success) {
                String errorMessage = ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCodedMsg();
                throw DriverUtils.createProcessorException(this.driverContext, ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode(), errorMessage, null, null);
            }
            try {
                this.compile(command, true, deferClose);
            }
            catch (CommandProcessorException cpe) {
                try {
                    this.driverTxnHandler.endTransactionAndCleanup(false);
                }
                catch (LockException e) {
                    LOG.warn("Exception in releasing locks", (Throwable)((Object)e));
                }
                this.saveErrorMessageAndRethrow(cpe);
            }
        }
        this.driverContext.getQueryDisplay().setPerfLogStarts(QueryDisplay.Phase.COMPILATION, perfLogger.getStartTimes());
        this.driverContext.getQueryDisplay().setPerfLogEnds(QueryDisplay.Phase.COMPILATION, perfLogger.getEndTimes());
    }

    @VisibleForTesting
    public int compile(String command, boolean resetTaskIds) {
        try {
            this.compile(command, resetTaskIds, false);
            return 0;
        }
        catch (CommandProcessorException cpr) {
            return cpr.getErrorCode();
        }
    }

    @VisibleForTesting
    public void compile(String command, boolean resetTaskIds, boolean deferClose) throws CommandProcessorException {
        this.prepareForCompile(resetTaskIds);
        Compiler compiler = new Compiler(this.context, this.driverContext, this.driverState);
        QueryPlan plan = compiler.compile(command, deferClose);
        this.driverContext.setPlan(plan);
        this.compileFinished(deferClose);
    }

    private void prepareForCompile(boolean resetTaskIds) throws CommandProcessorException {
        this.driverTxnHandler.createTxnManager();
        DriverState.setDriverState(this.driverState);
        this.prepareContext();
        this.setQueryId();
        if (resetTaskIds) {
            TaskFactory.resetId();
        }
    }

    private void prepareContext() throws CommandProcessorException {
        String originalCboInfo;
        String string = originalCboInfo = this.context != null ? this.context.cboInfo : null;
        if (this.context != null && this.context.getExplainAnalyze() != ExplainConfiguration.AnalyzeState.RUNNING) {
            if (!this.driverContext.isRetrial()) {
                this.closeInProcess(false);
            } else {
                this.context = new Context(this.context);
                this.releaseResources();
            }
        }
        if (this.context == null) {
            this.context = new Context((Configuration)this.driverContext.getConf());
            this.context.setCboInfo(originalCboInfo);
        }
        this.context.setHiveTxnManager(this.driverContext.getTxnManager());
        this.context.setStatsSource(this.driverContext.getStatsSource());
        this.context.setHDFSCleanup(true);
        this.driverTxnHandler.setContext(this.context);
        if (SessionState.get() != null) {
            QueryState queryState = this.getQueryState();
            SessionState.get().addQueryState(queryState.getQueryId(), queryState);
        }
    }

    private void setQueryId() {
        String queryId = Strings.isNullOrEmpty((String)this.driverContext.getQueryState().getQueryId()) ? QueryPlan.makeQueryId() : this.driverContext.getQueryState().getQueryId();
        this.driverContext.getQueryDisplay().setQueryId(queryId);
        this.setTriggerContext(queryId);
    }

    private void setTriggerContext(String queryId) {
        long queryStartTime = this.driverContext.getQueryStartTime();
        WmContext wmContext = new WmContext(queryStartTime, queryId);
        this.context.setWmContext(wmContext);
    }

    private void compileFinished(boolean deferClose) {
        if (DriverState.getDriverState().isAborted() && !deferClose) {
            this.closeInProcess(true);
        }
    }

    @Override
    public QueryPlan getPlan() {
        return this.driverContext.getPlan();
    }

    @Override
    public FetchTask getFetchTask() {
        return this.driverContext.getFetchTask();
    }

    public void releaseLocksAndCommitOrRollback(boolean commit) throws LockException {
        this.releaseLocksAndCommitOrRollback(commit, this.driverContext.getTxnManager());
    }

    @VisibleForTesting
    public void releaseLocksAndCommitOrRollback(boolean commit, HiveTxnManager txnManager) throws LockException {
        this.driverTxnHandler.endTransactionAndCleanup(commit, txnManager);
    }

    public void releaseResources() {
        this.releasePlan();
        this.releaseTaskQueue();
    }

    public PlanMapper getPlanMapper() {
        return this.context.getPlanMapper();
    }

    @Override
    public boolean isFetchingTable() {
        return this.driverContext.getFetchTask() != null;
    }

    @Override
    public Schema getSchema() {
        return this.driverContext.getSchema();
    }

    @Override
    public boolean hasResultSet() {
        for (Task<?> task : this.driverContext.getPlan().getRootTasks()) {
            if (task.getClass() != ExplainTask.class) continue;
            return true;
        }
        return this.driverContext.getPlan().getFetchTask() != null && this.driverContext.getPlan().getResultSchema() != null && this.driverContext.getPlan().getResultSchema().isSetFieldSchemas();
    }

    @Override
    public void resetFetch() throws IOException {
        if (this.driverState.isDestroyed() || this.driverState.isClosed()) {
            throw new IOException("FAILED: driver has been cancelled, closed or destroyed.");
        }
        if (this.isFetchingTable()) {
            try {
                this.driverContext.getFetchTask().resetFetch();
            }
            catch (Exception e) {
                throw new IOException("Error resetting the current fetch task", e);
            }
        } else {
            this.context.resetStream();
            this.driverContext.setResStream(null);
        }
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public boolean getResults(List results) throws IOException {
        if (this.driverState.isDestroyed() || this.driverState.isClosed()) {
            throw new IOException("FAILED: query has been cancelled, closed, or destroyed.");
        }
        if (this.isFetchingTable()) {
            return this.getFetchingTableResults(results);
        }
        if (this.driverContext.getResStream() == null) {
            DataInput contextStream = this.context.getStream();
            if (contextStream == null) {
                return false;
            }
            this.driverContext.setResStream(contextStream);
        }
        int numRows = 0;
        ByteStream.Output bos = new ByteStream.Output();
        while (numRows < this.maxRows) {
            Utilities.StreamStatus streamStatus;
            if (this.driverContext.getResStream() == null) {
                return numRows > 0;
            }
            bos.reset();
            try {
                streamStatus = Utilities.readColumn(this.driverContext.getResStream(), (OutputStream)bos);
                String row = this.getRow(bos, streamStatus);
                if (row != null) {
                    ++numRows;
                    results.add(row);
                }
            }
            catch (IOException e) {
                CONSOLE.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                return false;
            }
            if (streamStatus != Utilities.StreamStatus.EOF) continue;
            this.driverContext.setResStream(this.context.getStream());
        }
        return true;
    }

    private boolean getFetchingTableResults(List results) throws IOException {
        if (((FetchWork)this.driverContext.getFetchTask().getWork()).isUsingThriftJDBCBinarySerDe()) {
            this.maxRows = 1;
        }
        this.driverContext.getFetchTask().setMaxRows(this.maxRows);
        return this.driverContext.getFetchTask().fetch(results);
    }

    private String getRow(ByteStream.Output bos, Utilities.StreamStatus streamStatus) {
        String row = bos.getLength() > 0 ? new String(bos.getData(), 0, bos.getLength(), StandardCharsets.UTF_8) : (streamStatus == Utilities.StreamStatus.TERMINATED ? "" : null);
        return row;
    }

    @VisibleForTesting
    int closeInProcess(boolean destroyed) {
        this.releaseTaskQueue();
        this.releasePlan();
        this.releaseCachedResult();
        this.releaseFetchTask();
        this.releaseResStream();
        this.releaseContext();
        if (destroyed) {
            this.driverTxnHandler.release();
        }
        return 0;
    }

    @Override
    public void close() {
        this.logQueryHistory();
        this.driverState.lock();
        try {
            this.releaseTaskQueue();
            if (this.driverState.isCompiling() || this.driverState.isExecuting()) {
                this.driverState.abort();
            }
            this.releasePlan();
            this.releaseContext();
            this.releaseCachedResult();
            this.releaseFetchTask();
            this.releaseResStream();
            this.driverState.closed();
        }
        finally {
            this.driverState.unlock();
            DriverState.removeDriverState();
        }
        this.destroy();
    }

    private void logQueryHistory() {
        if (this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED)) {
            if (this.driverState.isClosed() || this.driverState.isDestroyed()) {
                LOG.warn("Driver instance {} already closed or destroyed, prevent handling query history", (Object)this);
            } else {
                QueryHistoryService.getInstance().logQuery(this.driverContext);
            }
        }
    }

    private void releaseTaskQueue() {
        this.driverState.lock();
        try {
            if (this.taskQueue != null) {
                this.taskQueue.shutdown();
                this.taskQueue = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while shutting down the task runner", (Throwable)e);
        }
        finally {
            this.driverState.unlock();
        }
    }

    private void releasePlan() {
        try {
            this.driverContext.setPlan(null);
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the Fetch task", (Throwable)e);
        }
    }

    private void releaseContext() {
        try {
            if (this.context != null) {
                boolean deleteResultDir = true;
                if (this.driverContext.getCacheUsage() != null && this.driverContext.getCacheUsage().getStatus() == CacheUsage.CacheStatus.QUERY_USING_CACHE) {
                    deleteResultDir = false;
                }
                this.context.clear(deleteResultDir);
                if (this.context.getHiveLocks() != null) {
                    this.driverTxnHandler.addHiveLocksFromContext();
                    this.context.setHiveLocks(null);
                }
                this.context = null;
            }
            if (SessionState.get() != null) {
                QueryState queryState = this.getQueryState();
                Map<Object, Object> queryCache = SessionState.get().getQueryCache(queryState.getQueryId());
                if (queryCache != null) {
                    queryCache.clear();
                }
                queryState.disableHMSCache();
                queryState.clearResourceMap();
                SessionState.get().removeQueryState(queryState.getQueryId());
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the context ", (Throwable)e);
        }
    }

    private void releaseResStream() {
        try {
            if (this.driverContext.getResStream() != null) {
                ((FSDataInputStream)this.driverContext.getResStream()).close();
                this.driverContext.setResStream(null);
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while closing the resStream ", (Throwable)e);
        }
    }

    private void releaseFetchTask() {
        try {
            if (this.driverContext.getFetchTask() != null) {
                this.driverContext.getFetchTask().clearFetch();
                this.driverContext.setFetchTask(null);
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while clearing the FetchTask ", (Throwable)e);
        }
    }

    private void releaseCachedResult() {
        if (this.driverContext.getUsedCacheEntry() != null) {
            this.driverContext.getUsedCacheEntry().releaseReader();
            this.driverContext.setUsedCacheEntry(null);
        } else if (this.hasBadCacheAttempt()) {
            try {
                QueryResultsCache.getInstance().removeEntry(this.driverContext.getCacheUsage().getCacheEntry());
            }
            catch (Exception err) {
                LOG.error("Error removing failed cache entry " + String.valueOf(this.driverContext.getCacheUsage().getCacheEntry()), (Throwable)err);
            }
        }
        this.driverContext.setCacheUsage(null);
    }

    private boolean hasBadCacheAttempt() {
        return this.driverContext.getCacheUsage() != null && this.driverContext.getCacheUsage().getStatus() == CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS && this.driverContext.getCacheUsage().getCacheEntry() != null;
    }

    @Override
    public void destroy() {
        this.driverState.lock();
        try {
            if (this.driverState.isDestroyed()) {
                return;
            }
            this.driverState.descroyed();
        }
        finally {
            this.driverState.unlock();
        }
        this.driverTxnHandler.destroy(this.driverContext.getQueryState().getQueryId());
    }

    @Override
    public QueryDisplay getQueryDisplay() {
        return this.driverContext.getQueryDisplay();
    }

    @Override
    public void setOperationId(String operationId) {
        this.driverContext.setOperationId(operationId);
    }

    @Override
    public QueryState getQueryState() {
        return this.driverContext.getQueryState();
    }

    public HookRunner getHookRunner() {
        return this.driverContext.getHookRunner();
    }

    public void setStatsSource(StatsSource runtimeStatsSource) {
        this.driverContext.setStatsSource(runtimeStatsSource);
    }

    public StatsSource getStatsSource() {
        return this.driverContext.getStatsSource();
    }

    private void saveErrorMessageAndRethrow(CommandProcessorException cpe) throws CommandProcessorException {
        this.driverContext.setQueryErrorMessage(cpe.getMessage());
        throw cpe;
    }
}

