/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlBasicFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SparkSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.SPARK).withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new SparkSqlDialect(DEFAULT_CONTEXT);
    private static final SqlFunction SPARKSQL_SUBSTRING = SqlBasicFunction.create("SUBSTRING", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.VARIADIC, SqlFunctionCategory.STRING);

    public SparkSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public JoinType emulateJoinTypeForCrossJoin() {
        return JoinType.CROSS;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        SparkSqlDialect.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            SqlUtil.unparseFunctionSyntax(SPARKSQL_SUBSTRING, writer, call, false);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                    TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                    SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                    SqlFloorFunction.unparseDatetimeFunction(writer, call2, "DATE_TRUNC", false);
                    break;
                }
                case TRIM: {
                    RelToSqlConverterUtil.unparseHiveTrim(writer, call, leftPrec, rightPrec);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }
}

