/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Table;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableTableScanRule
extends ConverterRule {
    public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalTableScan.class, r -> EnumerableTableScan.canHandle(r.getTable()), Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableTableScanRule").withRuleFactory(EnumerableTableScanRule::new);

    protected EnumerableTableScanRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        TableScan scan = (TableScan)rel;
        RelOptTable relOptTable = scan.getTable();
        Table table = relOptTable.unwrap(Table.class);
        if (table instanceof QueryableTable || relOptTable.getExpression(Object.class) != null) {
            return EnumerableTableScan.create(scan.getCluster(), relOptTable);
        }
        return null;
    }
}

