/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.scostore.ElementIteratorStatement;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractRDBMSQueryResult<E>
extends AbstractQueryResult<E> {
    private static final long serialVersionUID = 7264180157109169910L;
    protected ResultSet rs;
    protected ResultObjectFactory<E> rof;
    protected FetchPlan fp;
    protected Collection<AbstractMemberMetaData> bulkLoadedMmds;
    protected Map<Object, Map<Integer, Object>> bulkLoadedValueByMemberNumber;
    protected boolean closeStatementWithResultSet = true;
    boolean applyRangeChecks = false;

    public AbstractRDBMSQueryResult(Query query, ResultObjectFactory<E> rof, ResultSet rs, FetchPlan fp) {
        super(query);
        this.rof = rof;
        this.rs = rs;
        this.fp = fp;
        this.applyRangeChecks = !query.processesRangeInDatastoreQuery();
    }

    public void setCloseStatementWithResultSet(boolean flag) {
        this.closeStatementWithResultSet = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void registerMemberBulkResultSet(IteratorStatement iterStmt, ResultSet rs) {
        block65: {
            if (this.bulkLoadedValueByMemberNumber == null) {
                this.bulkLoadedValueByMemberNumber = new HashMap<Object, Map<Integer, Object>>();
            }
            if (this.bulkLoadedMmds == null) {
                this.bulkLoadedMmds = new HashSet<AbstractMemberMetaData>();
            }
            this.bulkLoadedMmds.add(iterStmt.getBackingStore().getOwnerMemberMetaData());
            ExecutionContext ec = this.query.getExecutionContext();
            AbstractMemberMetaData mmd = iterStmt.getBackingStore().getOwnerMemberMetaData();
            if (mmd.hasCollection() || mmd.hasArray()) {
                ElementIteratorStatement elemIterStmt = (ElementIteratorStatement)iterStmt;
                ElementContainerStore backingStore = (ElementContainerStore)iterStmt.getBackingStore();
                if (backingStore.isElementsAreEmbedded() || backingStore.isElementsAreSerialised()) {
                    int[] param = new int[backingStore.getElementMapping().getNumberOfColumnMappings()];
                    for (int i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (backingStore.getElementMapping() instanceof SerialisedPCMapping || backingStore.getElementMapping() instanceof SerialisedReferenceMapping || backingStore.getElementMapping() instanceof EmbeddedElementPCMapping) {
                        while (rs.next()) {
                            Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                            Object element = backingStore.getElementMapping().getObject(ec, rs, param, ec.findStateManager(owner), backingStore.getOwnerMemberMetaData().getAbsoluteFieldNumber());
                            this.addOwnerMemberCollectionElement(mmd, owner, element);
                        }
                    } else {
                        while (rs.next()) {
                            Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                            Object element = backingStore.getElementMapping().getObject(ec, rs, param);
                            this.addOwnerMemberCollectionElement(mmd, owner, element);
                        }
                    }
                } else if (backingStore.getElementMapping() instanceof ReferenceMapping) {
                    int[] param = new int[backingStore.getElementMapping().getNumberOfColumnMappings()];
                    for (int i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    while (rs.next()) {
                        Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                        Object element = backingStore.getElementMapping().getObject(ec, rs, param);
                        this.addOwnerMemberCollectionElement(mmd, owner, element);
                    }
                } else {
                    String elementType = mmd.hasCollection() ? backingStore.getOwnerMemberMetaData().getCollection().getElementType() : backingStore.getOwnerMemberMetaData().getArray().getElementType();
                    PersistentClassROF scoROF = new PersistentClassROF(ec, rs, this.fp, elemIterStmt.getElementClassMapping(), backingStore.getElementClassMetaData(), ec.getClassLoaderResolver().classForName(elementType));
                    scoROF.setIgnoreCache(this.query.getIgnoreCache());
                    while (rs.next()) {
                        Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                        Object element = scoROF.getObject();
                        this.addOwnerMemberCollectionElement(mmd, owner, element);
                    }
                }
                break block65;
            }
            if (mmd.hasMap()) {
                // empty if block
            }
        }
        try {
            Statement stmt = null;
            try {
                stmt = rs.getStatement();
                rs.close();
            }
            catch (SQLException e) {
                NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"052605", (Object[])new Object[]{e}));
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
        finally {
            rs = null;
        }
        catch (SQLException sqle) {
            try {
                NucleusLogger.DATASTORE.error((Object)("Exception thrown processing bulk loaded field " + iterStmt.getBackingStore().getOwnerMemberMetaData().getFullFieldName()), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                try {
                    Statement stmt = null;
                    try {
                        stmt = rs.getStatement();
                        rs.close();
                    }
                    catch (SQLException e) {
                        NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"052605", (Object[])new Object[]{e}));
                    }
                    finally {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                finally {
                    rs = null;
                }
                throw throwable;
            }
            try {
                Statement stmt = null;
                try {
                    stmt = rs.getStatement();
                    rs.close();
                }
                catch (SQLException e) {
                    NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"052605", (Object[])new Object[]{e}));
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                rs = null;
            }
        }
    }

    public abstract void initialise() throws SQLException;

    private void addOwnerMemberCollectionElement(AbstractMemberMetaData mmd, Object owner, Object element) {
        Object ownerId = this.api.getIdForObject(owner);
        Map<Integer, Object> fieldValuesForOwner = this.bulkLoadedValueByMemberNumber.get(ownerId);
        if (fieldValuesForOwner == null) {
            fieldValuesForOwner = new HashMap<Integer, Object>();
            this.bulkLoadedValueByMemberNumber.put(ownerId, fieldValuesForOwner);
        }
        if (mmd.hasCollection()) {
            Collection coll = (Collection)fieldValuesForOwner.get(mmd.getAbsoluteFieldNumber());
            if (coll == null) {
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    fieldValuesForOwner.put(mmd.getAbsoluteFieldNumber(), coll);
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            coll.add(element);
        } else if (mmd.hasArray()) {
            Object arr = fieldValuesForOwner.get(mmd.getAbsoluteFieldNumber());
            if (arr == null) {
                arr = Array.newInstance(mmd.getType().getComponentType(), 1);
                Array.set(arr, 0, element);
            } else {
                int currentSize = Array.getLength(arr);
                Object array = Array.newInstance(mmd.getType().getComponentType(), currentSize + 1);
                for (int i = 0; i < currentSize; ++i) {
                    Array.set(array, i, Array.get(arr, i));
                }
                Array.set(array, currentSize, element);
            }
        }
    }

    public void disconnect() {
        if (this.query == null) {
            return;
        }
        super.disconnect();
        this.rof = null;
        this.rs = null;
    }

    public synchronized void close() {
        super.close();
        this.rof = null;
        this.rs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResults() {
        if (this.rs != null) {
            try {
                Statement stmt = null;
                try {
                    stmt = this.rs.getStatement();
                    this.rs.close();
                }
                catch (SQLException e) {
                    NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"052605", (Object[])new Object[]{e}));
                }
                finally {
                    try {
                        if (this.closeStatementWithResultSet && stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                this.rs = null;
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AbstractRDBMSQueryResult)) {
            return false;
        }
        AbstractRDBMSQueryResult other = (AbstractRDBMSQueryResult)((Object)o);
        if (this.rs != null) {
            return other.rs == this.rs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)((Object)other)).equals(StringUtils.toJVMIDString((Object)((Object)this)));
    }

    public int hashCode() {
        if (this.rs != null) {
            return this.rs.hashCode();
        }
        if (this.query != null) {
            return this.query.hashCode();
        }
        return StringUtils.toJVMIDString((Object)((Object)this)).hashCode();
    }
}

