/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MapMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    @Override
    public Class getJavaType() {
        return Map.class;
    }

    @Override
    public void postInsert(DNStateManager ownerSM) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        Map value = (Map)ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && (this.mmd.getMap().keyIsPersistent() || this.mmd.getMap().valueIsPersistent())) {
                Set entries = value.entrySet();
                for (Map.Entry entry : entries) {
                    Object val;
                    Object key;
                    if (this.mmd.getMap().keyIsPersistent() && entry.getKey() != null && (ec.findStateManager(key = entry.getKey()) == null || ec.getApiAdapter().getExecutionContext(key) == null)) {
                        ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, key, false, ownerSM, this.mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_KEY_PC);
                    }
                    if (!this.mmd.getMap().valueIsPersistent() || entry.getValue() == null || ec.findStateManager(val = entry.getValue()) != null && ec.getApiAdapter().getExecutionContext(val) != null) continue;
                    ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, val, false, ownerSM, this.mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_VALUE_PC);
                }
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(ownerSM, null);
            return;
        }
        if (value.isEmpty()) {
            if (this.mmd.getRelationType(ec.getClassLoaderResolver()) == RelationType.MANY_TO_MANY_BI) {
                this.replaceFieldWithWrapper(ownerSM, null);
            } else {
                this.replaceFieldWithWrapper(ownerSM, value);
            }
        }
        if (this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007007", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            ApiAdapter api = ec.getApiAdapter();
            Set entries = value.entrySet();
            for (Map.Entry entry : entries) {
                if (api.isPersistable(entry.getKey()) && !api.isPersistent(entry.getKey()) && !api.isDetached(entry.getKey())) {
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || api.isPersistent(entry.getValue()) || api.isDetached(entry.getValue())) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getValue());
            }
        }
        ((MapStore)this.table.getStoreManager().getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass())).putAll(ownerSM, value, Collections.emptyMap());
        this.replaceFieldWithWrapper(ownerSM, value);
    }

    @Override
    public void postUpdate(DNStateManager ownerSM) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        Map value = (Map)ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && (this.mmd.getMap().keyIsPersistent() || this.mmd.getMap().valueIsPersistent())) {
                Set entries = value.entrySet();
                for (Map.Entry entry : entries) {
                    Object val;
                    Object key;
                    if (this.mmd.getMap().keyIsPersistent() && entry.getKey() != null && (ec.findStateManager(key = entry.getKey()) == null || ec.getApiAdapter().getExecutionContext(key) == null)) {
                        ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, key, false, ownerSM, this.mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_KEY_PC);
                    }
                    if (!this.mmd.getMap().valueIsPersistent() || entry.getValue() == null || ec.findStateManager(val = entry.getValue()) != null && ec.getApiAdapter().getExecutionContext(val) != null) continue;
                    ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, val, false, ownerSM, this.mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_MAP_VALUE_PC);
                }
            }
            return;
        }
        if (value == null) {
            ((MapStore)storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null)).clear(ownerSM);
            this.replaceFieldWithWrapper(ownerSM, null);
            return;
        }
        if (value instanceof BackedSCO) {
            ec.flushOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerSM);
            return;
        }
        if (this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007009", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007008", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)ownerSM.getInternalObjectId()), this.mmd.getFullFieldName()}));
            }
            return;
        }
        MapStore store = (MapStore)storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass());
        store.update(ownerSM, value);
        this.replaceFieldWithWrapper(ownerSM, value);
    }

    @Override
    public void preDelete(DNStateManager ownerSM) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        ownerSM.isLoaded(this.getAbsoluteFieldNumber());
        Map value = (Map)ownerSM.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        if (!(value instanceof SCO)) {
            value = (Map)SCOUtils.wrapSCOField((DNStateManager)ownerSM, (int)this.mmd.getAbsoluteFieldNumber(), (Object)value, (boolean)true);
        }
        value.clear();
        ownerSM.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerSM);
    }
}

