/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class OrcValueReaders {
    private OrcValueReaders() {
    }

    public static OrcValueReader<Boolean> booleans() {
        return BooleanReader.INSTANCE;
    }

    public static OrcValueReader<Integer> ints() {
        return IntegerReader.INSTANCE;
    }

    public static OrcValueReader<Long> longs() {
        return LongReader.INSTANCE;
    }

    public static OrcValueReader<Float> floats() {
        return FloatReader.INSTANCE;
    }

    public static OrcValueReader<Double> doubles() {
        return DoubleReader.INSTANCE;
    }

    public static OrcValueReader<byte[]> bytes() {
        return BytesReader.INSTANCE;
    }

    public static <C> OrcValueReader<C> constants(C constant) {
        return new ConstantReader<C>(constant);
    }

    private static class RowPositionReader
    implements OrcValueReader<Long> {
        private long batchOffsetInFile;

        private RowPositionReader() {
        }

        @Override
        public Long read(ColumnVector ignored, int row) {
            return this.batchOffsetInFile + (long)row;
        }

        @Override
        public Long nonNullRead(ColumnVector ignored, int row) {
            throw new UnsupportedOperationException("Use RowPositionReader.read()");
        }

        @Override
        public void setBatchContext(long newBatchOffsetInFile) {
            this.batchOffsetInFile = newBatchOffsetInFile;
        }
    }

    private static class ConstantReader<C>
    implements OrcValueReader<C> {
        private final C constant;

        private ConstantReader(C constant) {
            this.constant = constant;
        }

        @Override
        public C read(ColumnVector ignored, int ignoredRow) {
            return this.constant;
        }

        @Override
        public C nonNullRead(ColumnVector ignored, int ignoredRow) {
            return this.constant;
        }
    }

    public static abstract class StructReader<T>
    implements OrcValueReader<T> {
        private final OrcValueReader<?>[] readers;
        private final boolean[] isConstantOrMetadataField;

        protected StructReader(List<OrcValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
            List<Types.NestedField> fields = struct.fields();
            this.readers = new OrcValueReader[fields.size()];
            this.isConstantOrMetadataField = new boolean[fields.size()];
            int readerIndex = 0;
            for (int pos = 0; pos < fields.size(); ++pos) {
                Types.NestedField field = fields.get(pos);
                if (idToConstant.containsKey(field.fieldId())) {
                    this.isConstantOrMetadataField[pos] = true;
                    this.readers[pos] = OrcValueReaders.constants(idToConstant.get(field.fieldId()));
                    continue;
                }
                if (field.equals(MetadataColumns.ROW_POSITION)) {
                    this.isConstantOrMetadataField[pos] = true;
                    this.readers[pos] = new RowPositionReader();
                    continue;
                }
                if (field.equals(MetadataColumns.IS_DELETED)) {
                    this.isConstantOrMetadataField[pos] = true;
                    this.readers[pos] = OrcValueReaders.constants(false);
                    continue;
                }
                if (MetadataColumns.isMetadataColumn(field.name()) || field.type().typeId() == Type.TypeID.UNKNOWN) {
                    this.isConstantOrMetadataField[pos] = true;
                    this.readers[pos] = OrcValueReaders.constants(null);
                    continue;
                }
                this.readers[pos] = readers.get(readerIndex++);
            }
        }

        protected abstract T create();

        protected abstract void set(T var1, int var2, Object var3);

        public OrcValueReader<?> reader(int pos) {
            return this.readers[pos];
        }

        @Override
        public T nonNullRead(ColumnVector vector, int row) {
            StructColumnVector structVector = (StructColumnVector)vector;
            return this.readInternal(this.create(), structVector.fields, row);
        }

        private T readInternal(T struct, ColumnVector[] columnVectors, int row) {
            int vectorIndex = 0;
            for (int c = 0; c < this.readers.length; ++c) {
                ColumnVector vector;
                if (this.isConstantOrMetadataField[c]) {
                    vector = null;
                } else {
                    vector = columnVectors[vectorIndex];
                    ++vectorIndex;
                }
                this.set(struct, c, this.reader(c).read(vector, row));
            }
            return struct;
        }

        @Override
        public void setBatchContext(long batchOffsetInFile) {
            for (OrcValueReader<?> reader : this.readers) {
                reader.setBatchContext(batchOffsetInFile);
            }
        }
    }

    private static class BytesReader
    implements OrcValueReader<byte[]> {
        private static final BytesReader INSTANCE = new BytesReader();

        private BytesReader() {
        }

        @Override
        public byte[] nonNullRead(ColumnVector vector, int row) {
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            return Arrays.copyOfRange(bytesVector.vector[row], bytesVector.start[row], bytesVector.start[row] + bytesVector.length[row]);
        }
    }

    private static class DoubleReader
    implements OrcValueReader<Double> {
        private static final DoubleReader INSTANCE = new DoubleReader();

        private DoubleReader() {
        }

        @Override
        public Double nonNullRead(ColumnVector vector, int row) {
            return ((DoubleColumnVector)vector).vector[row];
        }
    }

    private static class FloatReader
    implements OrcValueReader<Float> {
        private static final FloatReader INSTANCE = new FloatReader();

        private FloatReader() {
        }

        @Override
        public Float nonNullRead(ColumnVector vector, int row) {
            return Float.valueOf((float)((DoubleColumnVector)vector).vector[row]);
        }
    }

    private static class LongReader
    implements OrcValueReader<Long> {
        static final LongReader INSTANCE = new LongReader();

        private LongReader() {
        }

        @Override
        public Long nonNullRead(ColumnVector vector, int row) {
            return ((LongColumnVector)vector).vector[row];
        }
    }

    private static class IntegerReader
    implements OrcValueReader<Integer> {
        static final IntegerReader INSTANCE = new IntegerReader();

        private IntegerReader() {
        }

        @Override
        public Integer nonNullRead(ColumnVector vector, int row) {
            return (int)((LongColumnVector)vector).vector[row];
        }
    }

    private static class BooleanReader
    implements OrcValueReader<Boolean> {
        static final BooleanReader INSTANCE = new BooleanReader();

        private BooleanReader() {
        }

        @Override
        public Boolean nonNullRead(ColumnVector vector, int row) {
            return ((LongColumnVector)vector).vector[row] != 0L;
        }
    }
}

