/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.hive.iceberg.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.iceberg.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.JsonUtil;

public class UpdateRequirementParser {
    private static final String TYPE = "type";
    static final String ASSERT_TABLE_UUID = "assert-table-uuid";
    static final String ASSERT_VIEW_UUID = "assert-view-uuid";
    static final String ASSERT_TABLE_DOES_NOT_EXIST = "assert-create";
    static final String ASSERT_REF_SNAPSHOT_ID = "assert-ref-snapshot-id";
    static final String ASSERT_LAST_ASSIGNED_FIELD_ID = "assert-last-assigned-field-id";
    static final String ASSERT_CURRENT_SCHEMA_ID = "assert-current-schema-id";
    static final String ASSERT_LAST_ASSIGNED_PARTITION_ID = "assert-last-assigned-partition-id";
    static final String ASSERT_DEFAULT_SPEC_ID = "assert-default-spec-id";
    static final String ASSERT_DEFAULT_SORT_ORDER_ID = "assert-default-sort-order-id";
    private static final String UUID = "uuid";
    private static final String NAME = "ref";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String LAST_ASSIGNED_FIELD_ID = "last-assigned-field-id";
    private static final String SCHEMA_ID = "current-schema-id";
    private static final String LAST_ASSIGNED_PARTITION_ID = "last-assigned-partition-id";
    private static final String SPEC_ID = "default-spec-id";
    private static final String SORT_ORDER_ID = "default-sort-order-id";
    private static final Map<Class<? extends UpdateRequirement>, String> TYPES = ImmutableMap.builder().put(UpdateRequirement.AssertTableUUID.class, "assert-table-uuid").put(UpdateRequirement.AssertViewUUID.class, "assert-view-uuid").put(UpdateRequirement.AssertTableDoesNotExist.class, "assert-create").put(UpdateRequirement.AssertRefSnapshotID.class, "assert-ref-snapshot-id").put(UpdateRequirement.AssertLastAssignedFieldId.class, "assert-last-assigned-field-id").put(UpdateRequirement.AssertCurrentSchemaID.class, "assert-current-schema-id").put(UpdateRequirement.AssertLastAssignedPartitionId.class, "assert-last-assigned-partition-id").put(UpdateRequirement.AssertDefaultSpecID.class, "assert-default-spec-id").put(UpdateRequirement.AssertDefaultSortOrderID.class, "assert-default-sort-order-id").buildOrThrow();

    private UpdateRequirementParser() {
    }

    public static String toJson(UpdateRequirement updateRequirement) {
        return UpdateRequirementParser.toJson(updateRequirement, false);
    }

    public static String toJson(UpdateRequirement updateRequirement, boolean pretty) {
        return JsonUtil.generate(gen -> UpdateRequirementParser.toJson(updateRequirement, gen), pretty);
    }

    public static void toJson(UpdateRequirement updateRequirement, JsonGenerator generator) throws IOException {
        String requirementType = TYPES.get(updateRequirement.getClass());
        generator.writeStartObject();
        generator.writeStringField(TYPE, requirementType);
        switch (requirementType) {
            case "assert-create": {
                break;
            }
            case "assert-table-uuid": {
                UpdateRequirementParser.writeAssertTableUUID((UpdateRequirement.AssertTableUUID)updateRequirement, generator);
                break;
            }
            case "assert-view-uuid": {
                UpdateRequirementParser.writeAssertViewUUID((UpdateRequirement.AssertViewUUID)updateRequirement, generator);
                break;
            }
            case "assert-ref-snapshot-id": {
                UpdateRequirementParser.writeAssertRefSnapshotId((UpdateRequirement.AssertRefSnapshotID)updateRequirement, generator);
                break;
            }
            case "assert-last-assigned-field-id": {
                UpdateRequirementParser.writeAssertLastAssignedFieldId((UpdateRequirement.AssertLastAssignedFieldId)updateRequirement, generator);
                break;
            }
            case "assert-last-assigned-partition-id": {
                UpdateRequirementParser.writeAssertLastAssignedPartitionId((UpdateRequirement.AssertLastAssignedPartitionId)updateRequirement, generator);
                break;
            }
            case "assert-current-schema-id": {
                UpdateRequirementParser.writeAssertCurrentSchemaId((UpdateRequirement.AssertCurrentSchemaID)updateRequirement, generator);
                break;
            }
            case "assert-default-spec-id": {
                UpdateRequirementParser.writeAssertDefaultSpecId((UpdateRequirement.AssertDefaultSpecID)updateRequirement, generator);
                break;
            }
            case "assert-default-sort-order-id": {
                UpdateRequirementParser.writeAssertDefaultSortOrderId((UpdateRequirement.AssertDefaultSortOrderID)updateRequirement, generator);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot convert update requirement to json. Unrecognized type: %s", requirementType));
            }
        }
        generator.writeEndObject();
    }

    public static UpdateRequirement fromJson(String json) {
        return JsonUtil.parse(json, UpdateRequirementParser::fromJson);
    }

    public static UpdateRequirement fromJson(JsonNode jsonNode) {
        String type;
        Preconditions.checkArgument(jsonNode != null && jsonNode.isObject(), "Cannot parse update requirement from non-object value: %s", (Object)jsonNode);
        Preconditions.checkArgument(jsonNode.hasNonNull(TYPE), "Cannot parse update requirement. Missing field: type");
        switch (type = JsonUtil.getString(TYPE, jsonNode).toLowerCase(Locale.ROOT)) {
            case "assert-create": {
                return UpdateRequirementParser.readAssertTableDoesNotExist(jsonNode);
            }
            case "assert-table-uuid": {
                return UpdateRequirementParser.readAssertTableUUID(jsonNode);
            }
            case "assert-view-uuid": {
                return UpdateRequirementParser.readAssertViewUUID(jsonNode);
            }
            case "assert-ref-snapshot-id": {
                return UpdateRequirementParser.readAssertRefSnapshotId(jsonNode);
            }
            case "assert-last-assigned-field-id": {
                return UpdateRequirementParser.readAssertLastAssignedFieldId(jsonNode);
            }
            case "assert-last-assigned-partition-id": {
                return UpdateRequirementParser.readAssertLastAssignedPartitionId(jsonNode);
            }
            case "assert-current-schema-id": {
                return UpdateRequirementParser.readAssertCurrentSchemaId(jsonNode);
            }
            case "assert-default-spec-id": {
                return UpdateRequirementParser.readAssertDefaultSpecId(jsonNode);
            }
            case "assert-default-sort-order-id": {
                return UpdateRequirementParser.readAssertDefaultSortOrderId(jsonNode);
            }
        }
        throw new UnsupportedOperationException(String.format("Unrecognized update requirement. Cannot convert to json: %s", type));
    }

    private static void writeAssertTableUUID(UpdateRequirement.AssertTableUUID requirement, JsonGenerator gen) throws IOException {
        gen.writeStringField(UUID, requirement.uuid());
    }

    private static void writeAssertViewUUID(UpdateRequirement.AssertViewUUID requirement, JsonGenerator gen) throws IOException {
        gen.writeStringField(UUID, requirement.uuid());
    }

    private static void writeAssertRefSnapshotId(UpdateRequirement.AssertRefSnapshotID requirement, JsonGenerator gen) throws IOException {
        gen.writeStringField(NAME, requirement.refName());
        if (requirement.snapshotId() != null) {
            gen.writeNumberField(SNAPSHOT_ID, requirement.snapshotId());
        } else {
            gen.writeNullField(SNAPSHOT_ID);
        }
    }

    private static void writeAssertLastAssignedFieldId(UpdateRequirement.AssertLastAssignedFieldId requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(LAST_ASSIGNED_FIELD_ID, requirement.lastAssignedFieldId());
    }

    private static void writeAssertLastAssignedPartitionId(UpdateRequirement.AssertLastAssignedPartitionId requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(LAST_ASSIGNED_PARTITION_ID, requirement.lastAssignedPartitionId());
    }

    private static void writeAssertCurrentSchemaId(UpdateRequirement.AssertCurrentSchemaID requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SCHEMA_ID, requirement.schemaId());
    }

    private static void writeAssertDefaultSpecId(UpdateRequirement.AssertDefaultSpecID requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SPEC_ID, requirement.specId());
    }

    private static void writeAssertDefaultSortOrderId(UpdateRequirement.AssertDefaultSortOrderID requirement, JsonGenerator gen) throws IOException {
        gen.writeNumberField(SORT_ORDER_ID, requirement.sortOrderId());
    }

    private static UpdateRequirement readAssertTableDoesNotExist(JsonNode node) {
        return new UpdateRequirement.AssertTableDoesNotExist();
    }

    private static UpdateRequirement readAssertTableUUID(JsonNode node) {
        String uuid = JsonUtil.getString(UUID, node);
        return new UpdateRequirement.AssertTableUUID(uuid);
    }

    private static UpdateRequirement readAssertViewUUID(JsonNode node) {
        String uuid = JsonUtil.getString(UUID, node);
        return new UpdateRequirement.AssertViewUUID(uuid);
    }

    private static UpdateRequirement readAssertRefSnapshotId(JsonNode node) {
        String name = JsonUtil.getString(NAME, node);
        Long snapshotId = JsonUtil.getLongOrNull(SNAPSHOT_ID, node);
        return new UpdateRequirement.AssertRefSnapshotID(name, snapshotId);
    }

    private static UpdateRequirement readAssertLastAssignedFieldId(JsonNode node) {
        int lastAssignedFieldId = JsonUtil.getInt(LAST_ASSIGNED_FIELD_ID, node);
        return new UpdateRequirement.AssertLastAssignedFieldId(lastAssignedFieldId);
    }

    private static UpdateRequirement readAssertCurrentSchemaId(JsonNode node) {
        int schemaId = JsonUtil.getInt(SCHEMA_ID, node);
        return new UpdateRequirement.AssertCurrentSchemaID(schemaId);
    }

    private static UpdateRequirement readAssertLastAssignedPartitionId(JsonNode node) {
        int lastAssignedPartitionId = JsonUtil.getInt(LAST_ASSIGNED_PARTITION_ID, node);
        return new UpdateRequirement.AssertLastAssignedPartitionId(lastAssignedPartitionId);
    }

    private static UpdateRequirement readAssertDefaultSpecId(JsonNode node) {
        int specId = JsonUtil.getInt(SPEC_ID, node);
        return new UpdateRequirement.AssertDefaultSpecID(specId);
    }

    private static UpdateRequirement readAssertDefaultSortOrderId(JsonNode node) {
        int sortOrderId = JsonUtil.getInt(SORT_ORDER_ID, node);
        return new UpdateRequirement.AssertDefaultSortOrderID(sortOrderId);
    }
}

