/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasTypesDef {
    private List<AtlasEnumDef> enumDefs;
    private List<AtlasStructDef> structDefs;
    private List<AtlasClassificationDef> classificationDefs;
    private List<AtlasEntityDef> entityDefs;
    private List<AtlasRelationshipDef> relationshipDefs;
    private List<AtlasBusinessMetadataDef> businessMetadataDefs;

    public AtlasTypesDef() {
        this.enumDefs = new ArrayList<AtlasEnumDef>();
        this.structDefs = new ArrayList<AtlasStructDef>();
        this.classificationDefs = new ArrayList<AtlasClassificationDef>();
        this.entityDefs = new ArrayList<AtlasEntityDef>();
        this.relationshipDefs = new ArrayList<AtlasRelationshipDef>();
        this.businessMetadataDefs = new ArrayList<AtlasBusinessMetadataDef>();
    }

    public AtlasTypesDef(List<AtlasEnumDef> enumDefs, List<AtlasStructDef> structDefs, List<AtlasClassificationDef> classificationDefs, List<AtlasEntityDef> entityDefs) {
        this(enumDefs, structDefs, classificationDefs, entityDefs, new ArrayList<AtlasRelationshipDef>(), new ArrayList<AtlasBusinessMetadataDef>());
    }

    public AtlasTypesDef(List<AtlasEnumDef> enumDefs, List<AtlasStructDef> structDefs, List<AtlasClassificationDef> classificationDefs, List<AtlasEntityDef> entityDefs, List<AtlasRelationshipDef> relationshipDefs) {
        this(enumDefs, structDefs, classificationDefs, entityDefs, relationshipDefs, new ArrayList<AtlasBusinessMetadataDef>());
    }

    public AtlasTypesDef(List<AtlasEnumDef> enumDefs, List<AtlasStructDef> structDefs, List<AtlasClassificationDef> classificationDefs, List<AtlasEntityDef> entityDefs, List<AtlasRelationshipDef> relationshipDefs, List<AtlasBusinessMetadataDef> businessMetadataDefs) {
        this.enumDefs = enumDefs;
        this.structDefs = structDefs;
        this.classificationDefs = classificationDefs;
        this.entityDefs = entityDefs;
        this.relationshipDefs = relationshipDefs;
        this.businessMetadataDefs = businessMetadataDefs;
    }

    public List<AtlasEnumDef> getEnumDefs() {
        return this.enumDefs;
    }

    public void setEnumDefs(List<AtlasEnumDef> enumDefs) {
        this.enumDefs = enumDefs;
    }

    public List<AtlasStructDef> getStructDefs() {
        return this.structDefs;
    }

    public void setStructDefs(List<AtlasStructDef> structDefs) {
        this.structDefs = structDefs;
    }

    public List<AtlasClassificationDef> getClassificationDefs() {
        return this.classificationDefs;
    }

    public List<AtlasEntityDef> getEntityDefs() {
        return this.entityDefs;
    }

    public void setEntityDefs(List<AtlasEntityDef> entityDefs) {
        this.entityDefs = entityDefs;
    }

    public void setClassificationDefs(List<AtlasClassificationDef> classificationDefs) {
        this.classificationDefs = classificationDefs;
    }

    public List<AtlasRelationshipDef> getRelationshipDefs() {
        return this.relationshipDefs;
    }

    public void setRelationshipDefs(List<AtlasRelationshipDef> relationshipDefs) {
        this.relationshipDefs = relationshipDefs;
    }

    public void setBusinessMetadataDefs(List<AtlasBusinessMetadataDef> businessMetadataDefs) {
        this.businessMetadataDefs = businessMetadataDefs;
    }

    public List<AtlasBusinessMetadataDef> getBusinessMetadataDefs() {
        return this.businessMetadataDefs;
    }

    public boolean hasClassificationDef(String name) {
        return this.hasTypeDef(this.classificationDefs, name);
    }

    public boolean hasEnumDef(String name) {
        return this.hasTypeDef(this.enumDefs, name);
    }

    public boolean hasStructDef(String name) {
        return this.hasTypeDef(this.structDefs, name);
    }

    public boolean hasEntityDef(String name) {
        return this.hasTypeDef(this.entityDefs, name);
    }

    public boolean hasRelationshipDef(String name) {
        return this.hasTypeDef(this.relationshipDefs, name);
    }

    public boolean hasBusinessMetadataDef(String name) {
        return this.hasTypeDef(this.businessMetadataDefs, name);
    }

    private <T extends AtlasBaseTypeDef> boolean hasTypeDef(Collection<T> typeDefs, String name) {
        if (CollectionUtils.isNotEmpty(typeDefs)) {
            for (AtlasBaseTypeDef typeDef : typeDefs) {
                if (!typeDef.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.enumDefs) && CollectionUtils.isEmpty(this.structDefs) && CollectionUtils.isEmpty(this.classificationDefs) && CollectionUtils.isEmpty(this.entityDefs) && CollectionUtils.isEmpty(this.relationshipDefs) && CollectionUtils.isEmpty(this.businessMetadataDefs);
    }

    public void clear() {
        if (this.enumDefs != null) {
            this.enumDefs.clear();
        }
        if (this.structDefs != null) {
            this.structDefs.clear();
        }
        if (this.classificationDefs != null) {
            this.classificationDefs.clear();
        }
        if (this.entityDefs != null) {
            this.entityDefs.clear();
        }
        if (this.relationshipDefs != null) {
            this.relationshipDefs.clear();
        }
        if (this.businessMetadataDefs != null) {
            this.businessMetadataDefs.clear();
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasTypesDef{");
        sb.append("enumDefs={");
        AtlasBaseTypeDef.dumpObjects(this.enumDefs, sb);
        sb.append("}");
        sb.append("structDefs={");
        AtlasBaseTypeDef.dumpObjects(this.structDefs, sb);
        sb.append("}");
        sb.append("classificationDefs={");
        AtlasBaseTypeDef.dumpObjects(this.classificationDefs, sb);
        sb.append("}");
        sb.append("entityDefs={");
        AtlasBaseTypeDef.dumpObjects(this.entityDefs, sb);
        sb.append("}");
        sb.append("relationshipDefs={");
        AtlasBaseTypeDef.dumpObjects(this.relationshipDefs, sb);
        sb.append("businessMetadataDefs={");
        AtlasBaseTypeDef.dumpObjects(this.businessMetadataDefs, sb);
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

