/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.http.ProfileServlet;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileOutputServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProfileOutputServlet.class);
    public static final String FILE_QUERY_PARAM = "file";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String queriedFile = req.getParameter(FILE_QUERY_PARAM);
        if (queriedFile == null) {
            this.writeMessage(resp, "Run the profiler to be able to receive its output");
            return;
        }
        Path outputDir = Paths.get(ProfileServlet.OUTPUT_DIR, new String[0]).toAbsolutePath().normalize();
        Path requestedPath = outputDir.resolve(queriedFile).normalize();
        if (!requestedPath.startsWith(outputDir)) {
            resp.setStatus(403);
            this.writeMessage(resp, "Access denied: Invalid Path");
            return;
        }
        File outputFile = requestedPath.toFile();
        if (outputFile.length() < 100L) {
            LOG.info("{} is incomplete. Sending auto-refresh header..", (Object)outputFile);
            resp.setHeader("Refresh", "2," + req.getRequestURI());
            resp.getWriter().write("This page will auto-refresh every 2 second until output file is ready..");
        } else {
            super.doGet(req, resp);
        }
    }

    private void writeMessage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/plain; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println(message);
        out.close();
    }
}

