/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.rtu;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagHandler;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusRtuADU;
import org.apache.plc4x.java.modbus.rtu.config.ModbusRtuConfiguration;
import org.apache.plc4x.java.modbus.rtu.protocol.ModbusRtuProtocolLogic;
import org.apache.plc4x.java.modbus.tcp.config.ModbusTcpTransportConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class ModbusRtuDriver
extends GeneratedDriverBase<ModbusRtuADU> {
    public String getProtocolCode() {
        return "modbus-rtu";
    }

    public String getProtocolName() {
        return "Modbus RTU";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return ModbusRtuConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(ModbusTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("serial");
    }

    protected List<String> getSupportedTransportCodes() {
        return Arrays.asList("tcp", "serial");
    }

    protected boolean awaitSetupComplete() {
        return false;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canPing() {
        return true;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    protected ModbusTagHandler getTagHandler() {
        return new ModbusTagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected ProtocolStackConfigurer<ModbusRtuADU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(ModbusRtuADU.class, (io, args) -> (ModbusRtuADU)ModbusRtuADU.staticParse(io, args)).withProtocol(ModbusRtuProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(new Object[]{DriverType.MODBUS_RTU, true}).build();
    }

    public ModbusTag prepareTag(String tagAddress) {
        return ModbusTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 1) {
                return byteBuf.readableBytes();
            }
            return -1;
        }
    }
}

