/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.tag;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;

public class ModbusTagHoldingRegister
extends ModbusTag {
    public static final String ADDRESS_PREFIX = "4x";
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("holding-register:" + ModbusTag.ADDRESS_PATTERN);
    public static final Pattern ADDRESS_SHORTER_PATTERN = Pattern.compile("4" + ModbusTag.FIXED_DIGIT_MODBUS_PATTERN);
    public static final Pattern ADDRESS_SHORT_PATTERN = Pattern.compile("4x" + ModbusTag.FIXED_DIGIT_MODBUS_PATTERN);
    protected static final int REGISTER_MAXADDRESS = 65535;

    protected ModbusTagHoldingRegister(int address, Integer quantity, ModbusDataType dataType) {
        super(address, quantity, dataType);
    }

    @Override
    protected String getAddressStringPrefix() {
        return ADDRESS_PREFIX;
    }

    @Override
    public int getLogicalAddress() {
        return this.getAddress() + 1;
    }

    public static boolean matches(String addressString) {
        return ADDRESS_PATTERN.matcher(addressString).matches() || ADDRESS_SHORTER_PATTERN.matcher(addressString).matches() || ADDRESS_SHORT_PATTERN.matcher(addressString).matches();
    }

    public static Matcher getMatcher(String addressString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = ADDRESS_SHORT_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        matcher = ADDRESS_SHORTER_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        throw new PlcInvalidTagException(addressString, ADDRESS_PATTERN);
    }

    public static ModbusTagHoldingRegister of(String addressString) {
        int quantity;
        Matcher matcher = ModbusTagHoldingRegister.getMatcher(addressString);
        int address = Integer.parseInt(matcher.group("address")) - 1;
        if (address > 65535) {
            throw new IllegalArgumentException("Address must be less than or equal to 65535. Was " + (address + 1));
        }
        String quantityString = matcher.group("quantity");
        int n = quantity = quantityString != null ? Integer.parseInt(quantityString) : 1;
        if (address + quantity > 65535) {
            throw new IllegalArgumentException("Last requested address is out of range, should be between 1 and 65535. Was " + (address + 1 + (quantity - 1)));
        }
        if (quantity > 125) {
            throw new IllegalArgumentException("quantity may not be larger than 125. Was " + quantity);
        }
        ModbusDataType dataType = matcher.group("datatype") != null ? ModbusDataType.valueOf(matcher.group("datatype")) : ModbusDataType.INT;
        return new ModbusTagHoldingRegister(address, quantity, dataType);
    }
}

