/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimePeriodUtil {
    private static final Logger log = LoggerFactory.getLogger(TimePeriodUtil.class);

    private TimePeriodUtil() {
    }

    public static TemporalAmount parseTokenTime(String tokenTime) {
        if (tokenTime == null || tokenTime.length() < 2) {
            log.error("tokenTime is invalid");
            return null;
        }
        if (Character.isUpperCase(tokenTime.charAt(tokenTime.length() - 1))) {
            return Period.parse("P" + tokenTime);
        }
        return Duration.parse("PT" + tokenTime);
    }

    public static long normalizeToMilliseconds(Object timestamp) {
        if (timestamp instanceof String) {
            String timestampStr = (String)timestamp;
            if (timestampStr.contains(".")) {
                double seconds = Double.parseDouble(timestampStr);
                return (long)(seconds * 1000.0);
            }
            long numericTimestamp = Long.parseLong(timestampStr);
            return TimePeriodUtil.convertNumericTimestamp(numericTimestamp);
        }
        if (timestamp instanceof Number) {
            if (timestamp instanceof Double || timestamp instanceof Float) {
                double seconds = ((Number)timestamp).doubleValue();
                return (long)(seconds * 1000.0);
            }
            long numericTimestamp = ((Number)timestamp).longValue();
            return TimePeriodUtil.convertNumericTimestamp(numericTimestamp);
        }
        throw new IllegalArgumentException("Not support this timestamp type: " + timestamp.getClass().getName());
    }

    private static long convertNumericTimestamp(long numericTimestamp) {
        if (String.valueOf(numericTimestamp).length() <= 10) {
            return numericTimestamp * 1000L;
        }
        return numericTimestamp;
    }
}

