/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.text.MessageFormat;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;

public class LogUtil {
    private static final String TEMPLATE_REGEX = "\\{\\d}";

    public static void debug(Logger logger, String msg, Object ... params) {
        if (logger.isDebugEnabled()) {
            if (ArrayUtils.isEmpty((Object[])params)) {
                logger.debug(LogUtil.buildLocationInfo() + msg);
            } else {
                logger.debug(LogUtil.buildLocationInfo() + LogUtil.format(msg, params));
            }
        }
    }

    public static void info(Logger logger, String msg, Object ... params) {
        if (logger.isInfoEnabled()) {
            if (ArrayUtils.isEmpty((Object[])params)) {
                logger.info(LogUtil.buildLocationInfo() + msg);
            } else {
                logger.info(LogUtil.buildLocationInfo() + LogUtil.format(msg, params));
            }
        }
    }

    public static void warn(Logger logger, String msg, Object ... params) {
        if (logger.isWarnEnabled()) {
            if (ArrayUtils.isEmpty((Object[])params)) {
                logger.warn(LogUtil.buildLocationInfo() + msg);
            } else {
                logger.warn(LogUtil.buildLocationInfo() + LogUtil.format(msg, params));
            }
        }
    }

    public static void error(Logger logger, String msg, Object ... params) {
        if (logger.isErrorEnabled()) {
            if (ArrayUtils.isEmpty((Object[])params)) {
                logger.error(LogUtil.buildLocationInfo() + msg);
            } else {
                logger.error(LogUtil.buildLocationInfo() + LogUtil.format(msg, params));
            }
        }
    }

    public static void warn(Logger logger, Throwable e, String msg, Object ... params) {
        if (logger.isWarnEnabled()) {
            if (ArrayUtils.isEmpty((Object[])params)) {
                logger.warn(LogUtil.buildLocationInfo() + msg, e);
            } else {
                logger.warn(LogUtil.buildLocationInfo() + LogUtil.format(msg, params), e);
            }
        }
    }

    public static void error(Logger logger, Throwable e, String msg, Object ... params) {
        if (logger.isErrorEnabled()) {
            if (ArrayUtils.isEmpty((Object[])params)) {
                logger.error(LogUtil.buildLocationInfo() + msg, e);
            } else {
                logger.error(LogUtil.buildLocationInfo() + LogUtil.format(msg, params), e);
            }
        }
    }

    private static String buildLocationInfo() {
        StringBuilder header = new StringBuilder();
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        for (int i = 0; i < stackTraceElements.length - 1; ++i) {
            StackTraceElement currentStackTrace = stackTraceElements[i];
            StackTraceElement nextStackTrace = stackTraceElements[i + 1];
            if (!LogUtil.class.getName().equals(currentStackTrace.getClassName()) || LogUtil.class.getName().equals(nextStackTrace.getClassName())) continue;
            String stackTrace = nextStackTrace.toString();
            header.append(" ").append(StringUtils.removeStart((String)stackTrace, (String)(nextStackTrace.getClassName() + ".")));
            break;
        }
        return header.append(":").toString();
    }

    private static String format(String msg, Object ... params) {
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return "";
        }
        if (params != null && params.length > 0) {
            msg = MessageFormat.format(msg, params);
        }
        return msg.replaceAll(TEMPLATE_REGEX, "");
    }

    private static String toString(Object object) {
        return ToStringBuilder.reflectionToString((Object)object, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

