/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.stereotype.Component;

@Converter
@Component
public class JsonStringListAttributeConverter
implements AttributeConverter<List<String>, String> {
    public String convertToDatabaseColumn(List<String> attribute) {
        return JsonUtil.toJson(attribute);
    }

    public List<String> convertToEntityAttribute(String dbData) {
        if (StringUtils.isBlank((CharSequence)dbData)) {
            return List.of();
        }
        if (!JsonUtil.isJsonStr(dbData)) {
            return List.of(dbData);
        }
        TypeReference<List<String>> typeReference = new TypeReference<List<String>>(){};
        List<String> stringList = JsonUtil.fromJson(dbData, typeReference);
        if (stringList == null && !dbData.isEmpty()) {
            return List.of(dbData);
        }
        return stringList;
    }
}

