/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.sd;

import java.util.List;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.registry.constant.DiscoveryClientInstance;
import org.apache.hertzbeat.collector.collect.registry.discovery.DiscoveryClient;
import org.apache.hertzbeat.collector.collect.registry.discovery.DiscoveryClientManagement;
import org.apache.hertzbeat.collector.collect.registry.discovery.entity.ServiceInstance;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.ConsulSdProtocol;
import org.apache.hertzbeat.common.entity.job.protocol.RegistryProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ConsulSdCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(ConsulSdCollectImpl.class);
    private static final DiscoveryClientManagement discoveryClientManagement = new DiscoveryClientManagement();

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        ConsulSdProtocol consulSd = metrics.getConsul_sd();
        if (consulSd == null || consulSd.isInvalid()) {
            throw new IllegalArgumentException("Consul Service Discovery params is required.");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        RegistryProtocol registryProtocol = RegistryProtocol.builder().host(metrics.getConsul_sd().getHost()).port(metrics.getConsul_sd().getPort()).discoveryClientTypeName(DiscoveryClientInstance.CONSUL.name()).build();
        try (DiscoveryClient client = discoveryClientManagement.getClient(registryProtocol);){
            List<ServiceInstance> services = client.getServices();
            if (CollectionUtils.isEmpty(services)) {
                return;
            }
            services.forEach(instance -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                valueRowBuilder.addColumn(instance.getAddress());
                valueRowBuilder.addColumn(String.valueOf(instance.getPort()));
                builder.addValueRow(valueRowBuilder.build());
            });
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("Failed to fetch consul sd... {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    public String supportProtocol() {
        return "consul_sd";
    }
}

