/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.prometheus.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.collector.collect.http.promethus.ParseException;
import org.apache.hertzbeat.collector.collect.prometheus.parser.MetricFamily;
import org.apache.hertzbeat.common.util.StrBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="1.7.0")
public class TextParser {
    private static final Logger log = LoggerFactory.getLogger(TextParser.class);
    private static final String NAME_LABEL = "__name__";
    private static final char LEFT_CURLY_BRACKET = '{';
    private static final char RIGHT_CURLY_BRACKET = '}';
    private static final char EQUALS = '=';
    private static final char QUOTES = '\"';
    private static final char ENTER = '\n';
    private static final char SPACE = ' ';
    private static final char COMMA = ',';

    public static Map<String, MetricFamily> textToMetricFamilies(String resp) {
        ConcurrentHashMap<String, MetricFamily> metricMap = new ConcurrentHashMap<String, MetricFamily>(10);
        try {
            String[] lines;
            for (String line : lines = resp.split("\n")) {
                TextParser.parseLine(metricMap, new StrBuffer(line));
            }
            return metricMap;
        }
        catch (Exception e) {
            log.error("parse prometheus exporter data error, msg: {}", (Object)e.getMessage(), (Object)e);
            return metricMap;
        }
    }

    private static void parseLine(Map<String, MetricFamily> metricMap, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        switch (buffer.charAt(0)) {
            case '\n': 
            case '#': {
                break;
            }
            default: {
                TextParser.parseMetric(metricMap, buffer);
            }
        }
    }

    private static void parseMetric(Map<String, MetricFamily> metricMap, StrBuffer buffer) {
        String metricName = TextParser.readTokenAsMetricName(buffer);
        if (metricName.isEmpty()) {
            log.error("error parse metric, metric name is null, line: {}", (Object)buffer.toStr());
            return;
        }
        MetricFamily currentMetricFamily = metricMap.computeIfAbsent(metricName, key -> new MetricFamily());
        List<MetricFamily.Metric> metricList = currentMetricFamily.getMetricList();
        if (metricList == null) {
            metricList = new ArrayList<MetricFamily.Metric>();
            currentMetricFamily.setMetricList(metricList);
        }
        MetricFamily.Metric metric = new MetricFamily.Metric();
        metricList.add(metric);
        TextParser.readLabels(metric, buffer);
    }

    private static void readLabels(MetricFamily.Metric metric, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        metric.setLabels(new LinkedList<MetricFamily.Label>());
        if (buffer.charAt(0) == '{') {
            buffer.read();
            TextParser.startReadLabelName(metric, buffer);
        } else {
            TextParser.readLabelValue(metric, buffer);
        }
    }

    private static void startReadLabelName(MetricFamily.Metric metric, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        if (buffer.charAt(0) == '}') {
            buffer.read();
            buffer.skipBlankTabs();
            if (buffer.isEmpty()) {
                return;
            }
            TextParser.readLabelValue(metric, buffer);
            return;
        }
        String labelName = TextParser.readTokenAsLabelName(buffer);
        if (labelName.isEmpty() || NAME_LABEL.equals(labelName)) {
            throw new ParseException("invalid label name" + labelName + ", label name size = 0 or label name equals __name__");
        }
        MetricFamily.Label label = new MetricFamily.Label();
        label.setName(labelName);
        if (buffer.read() != '=') {
            throw new ParseException("parse error, not match the format of labelName=labelValue");
        }
        TextParser.startReadLabelValue(metric, label, buffer);
    }

    private static void startReadLabelValue(MetricFamily.Metric metric, MetricFamily.Label label, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        char c = buffer.read();
        if (c != '\"') {
            throw new ParseException("expected '\"' at start of label value, line: " + buffer.toStr());
        }
        String labelValue = TextParser.readTokenAsLabelValue(buffer);
        label.setValue(labelValue);
        if (!TextParser.isValidLabelValue(labelValue)) {
            throw new ParseException("no valid label value: " + labelValue);
        }
        metric.getLabels().add(label);
        if (buffer.isEmpty()) {
            return;
        }
        c = buffer.read();
        switch (c) {
            case ',': {
                TextParser.startReadLabelName(metric, buffer);
                break;
            }
            case '}': {
                TextParser.readLabelValue(metric, buffer);
                break;
            }
            default: {
                throw new ParseException("expected '}' or ',' at end of label value, line: " + buffer.toStr());
            }
        }
    }

    private static void readLabelValue(MetricFamily.Metric metric, StrBuffer buffer) {
        buffer.skipBlankTabs();
        if (buffer.isEmpty()) {
            return;
        }
        metric.setValue(buffer.toDouble());
    }

    private static String readTokenAsMetricName(StrBuffer buffer) {
        buffer.skipBlankTabs();
        StringBuilder builder = new StringBuilder();
        if (TextParser.isValidMetricNameStart(buffer.charAt(0))) {
            while (!buffer.isEmpty()) {
                char c = buffer.read();
                if (!TextParser.isValidMetricNameContinuation(c)) {
                    buffer.rollback();
                    break;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        throw new ParseException("parse metric name error");
    }

    private static String readTokenAsLabelName(StrBuffer buffer) {
        buffer.skipBlankTabs();
        StringBuilder builder = new StringBuilder();
        char c = buffer.read();
        if (TextParser.isValidLabelNameStart(c)) {
            builder.append(c);
            while (!buffer.isEmpty()) {
                c = buffer.read();
                if (!TextParser.isValidLabelNameContinuation(c)) {
                    buffer.rollback();
                    break;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        throw new ParseException("parse label name error");
    }

    private static String readTokenAsLabelValue(StrBuffer buffer) {
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        block9: while (!buffer.isEmpty()) {
            char c = buffer.read();
            if (escaped) {
                switch (c) {
                    case '\"': 
                    case '\\': {
                        builder.append(c);
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    default: {
                        throw new ParseException("parse label value error");
                    }
                }
                escaped = false;
                continue;
            }
            switch (c) {
                case '\"': {
                    return builder.toString();
                }
                case '\n': {
                    throw new ParseException("parse label value error, next line");
                }
                case '\\': {
                    escaped = true;
                    continue block9;
                }
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean isValidMetricNameStart(char c) {
        return TextParser.isValidLabelNameStart(c) || c == ':';
    }

    private static boolean isValidMetricNameContinuation(char c) {
        return TextParser.isValidLabelNameContinuation(c) || c == ':';
    }

    private static boolean isValidLabelNameStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isValidLabelNameContinuation(char c) {
        return TextParser.isValidLabelNameStart(c) || c >= '0' && c <= '9';
    }

    private static boolean isValidLabelValue(String s) {
        return s != null;
    }
}

