/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProducerRequest;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.RecordMetadata;

final class KafkaProducerAttributesExtractor
implements AttributesExtractor<KafkaProducerRequest, RecordMetadata> {
    private static final AttributeKey<String> MESSAGING_DESTINATION_PARTITION_ID = AttributeKey.stringKey((String)"messaging.destination.partition.id");
    private static final AttributeKey<String> MESSAGING_KAFKA_MESSAGE_KEY = AttributeKey.stringKey((String)"messaging.kafka.message.key");
    private static final AttributeKey<Long> MESSAGING_KAFKA_MESSAGE_OFFSET = AttributeKey.longKey((String)"messaging.kafka.message.offset");
    private static final AttributeKey<Boolean> MESSAGING_KAFKA_MESSAGE_TOMBSTONE = AttributeKey.booleanKey((String)"messaging.kafka.message.tombstone");

    KafkaProducerAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaProducerRequest request) {
        Object key = request.getRecord().key();
        if (key != null && KafkaProducerAttributesExtractor.canSerialize(key.getClass())) {
            attributes.put(MESSAGING_KAFKA_MESSAGE_KEY, (Object)key.toString());
        }
        if (request.getRecord().value() == null) {
            attributes.put(MESSAGING_KAFKA_MESSAGE_TOMBSTONE, (Object)true);
        }
    }

    private static boolean canSerialize(Class<?> keyClass) {
        return !keyClass.isArray() && keyClass != ByteBuffer.class;
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaProducerRequest request, @Nullable RecordMetadata recordMetadata, @Nullable Throwable error) {
        if (recordMetadata != null) {
            attributes.put(MESSAGING_DESTINATION_PARTITION_ID, (Object)String.valueOf(recordMetadata.partition()));
            attributes.put(MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)recordMetadata.offset());
        }
    }
}

