/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.signal;

import io.greptime.common.signal.Signal;
import io.greptime.common.signal.SignalHandler;
import io.greptime.common.signal.SignalHelper;
import io.greptime.common.util.ServiceLoader;
import io.greptime.common.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHandlersLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SignalHandlersLoader.class);
    private static final boolean USE_OS_SIGNAL = SystemPropertyUtil.getBool("greptimedb.use_os_signal", true);

    public static void load() {
        try {
            if (USE_OS_SIGNAL && SignalHelper.supportSignal()) {
                List<SignalHandler> handlers = ServiceLoader.load(SignalHandler.class).sort();
                LOG.info("Loaded signals: {}.", handlers);
                HashMap<Signal, List> mapTo = new HashMap<Signal, List>();
                handlers.forEach(h -> mapTo.computeIfAbsent(h.signal(), sig -> new ArrayList()).add(h));
                mapTo.forEach((sig, hs) -> {
                    boolean success = SignalHelper.addSignal(sig, hs);
                    LOG.info("Add signal [{}] handler {} {}.", new Object[]{sig, hs, success ? "success" : "failed"});
                });
            }
        }
        catch (Throwable t) {
            LOG.error("Fail to add signal.", t);
        }
    }
}

