/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class BufferByteOutput<T extends ByteBuffer>
extends AbstractByteOutput<T> {
    public static BufferByteOutput<ByteBuffer> of(final int capacity, final WritableByteChannel channel) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity(" + capacity + ") <= 0");
        }
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        return new BufferByteOutput<ByteBuffer>(null){

            @Override
            public void write(int value) throws IOException {
                if (this.target == null) {
                    this.target = ByteBuffer.allocate(capacity);
                }
                if (!((ByteBuffer)this.target).hasRemaining()) {
                    ((ByteBuffer)this.target).flip();
                    do {
                        channel.write((ByteBuffer)this.target);
                    } while (((ByteBuffer)this.target).position() == 0);
                    ((ByteBuffer)this.target).compact();
                }
                super.write(value);
            }

            @Override
            public void setTarget(ByteBuffer target) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int flush(BufferByteOutput<?> output, WritableByteChannel channel) throws IOException {
        ByteBuffer buffer = (ByteBuffer)output.getTarget();
        if (buffer == null) {
            return 0;
        }
        int written = 0;
        buffer.flip();
        while (buffer.hasRemaining()) {
            written += channel.write(buffer);
        }
        buffer.clear();
        return written;
    }

    public BufferByteOutput(T target) {
        super(target);
    }

    @Override
    public void write(int value) throws IOException {
        ((ByteBuffer)this.getTarget()).put((byte)value);
    }

    @Override
    public BufferByteOutput<T> target(T target) {
        return (BufferByteOutput)super.target(target);
    }
}

