/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.FastCodesHeader;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class RocketMQSerializable {
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;

    public static void writeStr(ByteBuf buf, boolean useShortLength, String str) {
        int lenIndex = buf.writerIndex();
        if (useShortLength) {
            buf.writeShort(0);
        } else {
            buf.writeInt(0);
        }
        int len = buf.writeCharSequence((CharSequence)str, StandardCharsets.UTF_8);
        if (useShortLength) {
            buf.setShort(lenIndex, len);
        } else {
            buf.setInt(lenIndex, len);
        }
    }

    private static String readStr(ByteBuf buf, boolean useShortLength, int limit) throws RemotingCommandException {
        int len;
        int n = len = useShortLength ? buf.readShort() : buf.readInt();
        if (len == 0) {
            return null;
        }
        if (len > limit) {
            throw new RemotingCommandException("string length exceed limit:" + limit);
        }
        CharSequence cs = buf.readCharSequence(len, StandardCharsets.UTF_8);
        return cs == null ? null : cs.toString();
    }

    public static int rocketMQProtocolEncode(RemotingCommand cmd, ByteBuf out) {
        HashMap<String, String> map;
        int beginIndex = out.writerIndex();
        out.writeShort(cmd.getCode());
        out.writeByte((int)cmd.getLanguage().getCode());
        out.writeShort(cmd.getVersion());
        out.writeInt(cmd.getOpaque());
        out.writeInt(cmd.getFlag());
        String remark = cmd.getRemark();
        if (remark != null && !remark.isEmpty()) {
            RocketMQSerializable.writeStr(out, false, remark);
        } else {
            out.writeInt(0);
        }
        int mapLenIndex = out.writerIndex();
        out.writeInt(0);
        if (cmd.readCustomHeader() instanceof FastCodesHeader) {
            ((FastCodesHeader)((Object)cmd.readCustomHeader())).encode(out);
        }
        if ((map = cmd.getExtFields()) != null && !map.isEmpty()) {
            map.forEach((k, v) -> {
                if (k != null && v != null) {
                    RocketMQSerializable.writeStr(out, true, k);
                    RocketMQSerializable.writeStr(out, false, v);
                }
            });
        }
        out.setInt(mapLenIndex, out.writerIndex() - mapLenIndex - 4);
        return out.writerIndex() - beginIndex;
    }

    public static byte[] rocketMQProtocolEncode(RemotingCommand cmd) {
        byte[] remarkBytes = null;
        int remarkLen = 0;
        if (cmd.getRemark() != null && cmd.getRemark().length() > 0) {
            remarkBytes = cmd.getRemark().getBytes(CHARSET_UTF8);
            remarkLen = remarkBytes.length;
        }
        byte[] extFieldsBytes = null;
        int extLen = 0;
        if (cmd.getExtFields() != null && !cmd.getExtFields().isEmpty()) {
            extFieldsBytes = RocketMQSerializable.mapSerialize(cmd.getExtFields());
            extLen = extFieldsBytes.length;
        }
        int totalLen = RocketMQSerializable.calTotalLen(remarkLen, extLen);
        ByteBuffer headerBuffer = ByteBuffer.allocate(totalLen);
        headerBuffer.putShort((short)cmd.getCode());
        headerBuffer.put(cmd.getLanguage().getCode());
        headerBuffer.putShort((short)cmd.getVersion());
        headerBuffer.putInt(cmd.getOpaque());
        headerBuffer.putInt(cmd.getFlag());
        if (remarkBytes != null) {
            headerBuffer.putInt(remarkBytes.length);
            headerBuffer.put(remarkBytes);
        } else {
            headerBuffer.putInt(0);
        }
        if (extFieldsBytes != null) {
            headerBuffer.putInt(extFieldsBytes.length);
            headerBuffer.put(extFieldsBytes);
        } else {
            headerBuffer.putInt(0);
        }
        return headerBuffer.array();
    }

    public static byte[] mapSerialize(HashMap<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        int totalLength = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            int kvLength = 2 + entry.getKey().getBytes(CHARSET_UTF8).length + 4 + entry.getValue().getBytes(CHARSET_UTF8).length;
            totalLength += kvLength;
        }
        ByteBuffer content = ByteBuffer.allocate(totalLength);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            byte[] key = entry.getKey().getBytes(CHARSET_UTF8);
            byte[] val = entry.getValue().getBytes(CHARSET_UTF8);
            content.putShort((short)key.length);
            content.put(key);
            content.putInt(val.length);
            content.put(val);
        }
        return content.array();
    }

    private static int calTotalLen(int remark, int ext) {
        int length = 17 + remark + 4 + ext;
        return length;
    }

    public static RemotingCommand rocketMQProtocolDecode(ByteBuf headerBuffer, int headerLen) throws RemotingCommandException {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(headerBuffer.readShort());
        cmd.setLanguage(LanguageCode.valueOf(headerBuffer.readByte()));
        cmd.setVersion(headerBuffer.readShort());
        cmd.setOpaque(headerBuffer.readInt());
        cmd.setFlag(headerBuffer.readInt());
        cmd.setRemark(RocketMQSerializable.readStr(headerBuffer, false, headerLen));
        int extFieldsLength = headerBuffer.readInt();
        if (extFieldsLength > 0) {
            if (extFieldsLength > headerLen) {
                throw new RemotingCommandException("RocketMQ protocol decoding failed, extFields length: " + extFieldsLength + ", but header length: " + headerLen);
            }
            cmd.setExtFields(RocketMQSerializable.mapDeserialize(headerBuffer, extFieldsLength));
        }
        return cmd;
    }

    public static HashMap<String, String> mapDeserialize(ByteBuf byteBuffer, int len) throws RemotingCommandException {
        HashMap<String, String> map = new HashMap<String, String>();
        int endIndex = byteBuffer.readerIndex() + len;
        while (byteBuffer.readerIndex() < endIndex) {
            String k = RocketMQSerializable.readStr(byteBuffer, true, len);
            String v = RocketMQSerializable.readStr(byteBuffer, false, len);
            map.put(k, v);
        }
        return map;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

