/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import com.jcraft.jzlib.ZInputStream;
import com.jcraft.jzlib.ZOutputStream;
import dm.jdbc.driver.DBError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xerial.snappy.Snappy;

public class JZipUtil {
    public static byte[] compress(byte[] byArray, int n2) {
        try {
            if (n2 == 1) {
                return Snappy.compress((byte[])byArray);
            }
            return JZipUtil.jzlibCompress(byArray);
        }
        catch (Throwable throwable) {
            DBError.throwRuntimeException("compress error!", throwable);
            return new byte[0];
        }
    }

    public static byte[] uncompress(byte[] byArray, int n2) {
        try {
            if (n2 == 1) {
                return Snappy.uncompress((byte[])byArray);
            }
            return JZipUtil.jzlibUncompress(byArray);
        }
        catch (Throwable throwable) {
            DBError.throwRuntimeException("uncompress error!", throwable);
            return new byte[0];
        }
    }

    public static byte[] jzlibCompress(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZOutputStream zOutputStream = new ZOutputStream((OutputStream)byteArrayOutputStream, -1);
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)zOutputStream);
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            zOutputStream.close();
            byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray2;
    }

    public static byte[] jzlibUncompress(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ZInputStream zInputStream = new ZInputStream((InputStream)byteArrayInputStream);
            byte[] byArray3 = new byte[1024];
            int n2 = -1;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = zInputStream.read(byArray3, 0, byArray3.length)) != -1) {
                byteArrayOutputStream.write(byArray3, 0, n2);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            zInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray2;
    }

    public static void main(String[] stringArray) {
        String string = "\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd";
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[100];
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        System.out.println("\u539f\u59cb\u6570\u636e\uff1a");
        int n2 = 0;
        while (n2 < byArray.length) {
            System.out.print(String.valueOf(byArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
        System.out.println("<\u65b9\u6cd51>");
        byArray2 = JZipUtil.jzlibCompress(byArray);
        long l2 = byArray2.length;
        System.out.println("\u538b\u7f29\u540e\u7684\u6570\u636e\uff1a");
        n2 = 0;
        while ((long)n2 < l2) {
            System.out.print(String.valueOf(byArray2[n2]) + " ");
            ++n2;
        }
        byArray3 = new byte[(int)l2];
        n2 = 0;
        while ((long)n2 < l2) {
            byArray3[n2] = byArray2[n2];
            ++n2;
        }
        byArray4 = JZipUtil.jzlibUncompress(byArray3);
        System.out.println("\n\u89e3\u538b\u540e\u7684\u6570\u636e\uff1a");
        n2 = 0;
        while (n2 < byArray4.length) {
            System.out.print(String.valueOf(byArray4[n2]) + " ");
            ++n2;
        }
        System.out.println();
        System.out.println("<\u65b9\u6cd52>");
        byte[] byArray5 = JZipUtil.jzlibCompress(byArray);
        System.out.println("\u538b\u7f29\u540e\u7684\u6570\u636e\uff1a");
        int n3 = 0;
        while (n3 < byArray5.length) {
            System.out.print(String.valueOf(byArray5[n3]) + " ");
            ++n3;
        }
        byte[] byArray6 = JZipUtil.jzlibUncompress(byArray5);
        System.out.println("\n\u89e3\u538b\u540e\u7684\u6570\u636e\uff1a");
        int n4 = 0;
        while (n4 < byArray6.length) {
            System.out.print(String.valueOf(byArray6[n4]) + " ");
            ++n4;
        }
    }
}

