/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.api.config.HelixConfigProperty;
import org.apache.helix.api.config.RebalanceConfig;
import org.apache.helix.api.config.StateTransitionTimeoutConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConfig
extends HelixProperty {
    private static final Logger _logger = LoggerFactory.getLogger((String)ResourceConfig.class.getName());
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    public static final String DEFAULT_PARTITION_KEY = "DEFAULT";
    private Map<String, Map<String, Integer>> _deserializedPartitionCapacityMap;

    public ResourceConfig(String resourceId) {
        super(resourceId);
    }

    public ResourceConfig(ZNRecord record) {
        super(record);
    }

    public ResourceConfig(ZNRecord record, String id) {
        super(record, id);
    }

    public ResourceConfig(String resourceId, Boolean monitorDisabled, int numPartitions, String stateModelDefRef, String stateModelFactoryName, String numReplica, int minActiveReplica, int maxPartitionsPerInstance, String instanceGroupTag, Boolean helixEnabled, String resourceGroupName, String resourceType, Boolean groupRoutingEnabled, Boolean externalViewDisabled, RebalanceConfig rebalanceConfig, StateTransitionTimeoutConfig stateTransitionTimeoutConfig, Map<String, List<String>> listFields, Map<String, Map<String, String>> mapFields, Boolean p2pMessageEnabled) {
        this(resourceId, monitorDisabled, numPartitions, stateModelDefRef, stateModelFactoryName, numReplica, minActiveReplica, maxPartitionsPerInstance, instanceGroupTag, helixEnabled, resourceGroupName, resourceType, groupRoutingEnabled, externalViewDisabled, rebalanceConfig, stateTransitionTimeoutConfig, listFields, mapFields, p2pMessageEnabled, null);
    }

    private ResourceConfig(String resourceId, Boolean monitorDisabled, int numPartitions, String stateModelDefRef, String stateModelFactoryName, String numReplica, int minActiveReplica, int maxPartitionsPerInstance, String instanceGroupTag, Boolean helixEnabled, String resourceGroupName, String resourceType, Boolean groupRoutingEnabled, Boolean externalViewDisabled, RebalanceConfig rebalanceConfig, StateTransitionTimeoutConfig stateTransitionTimeoutConfig, Map<String, List<String>> listFields, Map<String, Map<String, String>> mapFields, Boolean p2pMessageEnabled, Map<String, Map<String, Integer>> partitionCapacityMap) {
        super(resourceId);
        if (monitorDisabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.MONITORING_DISABLED.name(), monitorDisabled);
        }
        if (p2pMessageEnabled != null) {
            this._record.setBooleanField(HelixConfigProperty.P2P_MESSAGE_ENABLED.name(), p2pMessageEnabled);
        }
        if (numPartitions > 0) {
            this._record.setIntField(ResourceConfigProperty.NUM_PARTITIONS.name(), numPartitions);
        }
        if (stateModelDefRef != null) {
            this._record.setSimpleField(ResourceConfigProperty.STATE_MODEL_DEF_REF.name(), stateModelDefRef);
        }
        if (stateModelFactoryName != null) {
            this._record.setSimpleField(ResourceConfigProperty.STATE_MODEL_FACTORY_NAME.name(), stateModelFactoryName);
        }
        if (numReplica != null) {
            this._record.setSimpleField(ResourceConfigProperty.REPLICAS.name(), numReplica);
        }
        if (minActiveReplica >= 0) {
            this._record.setIntField(ResourceConfigProperty.MIN_ACTIVE_REPLICAS.name(), minActiveReplica);
        }
        if (maxPartitionsPerInstance >= 0) {
            this._record.setIntField(ResourceConfigProperty.MAX_PARTITIONS_PER_INSTANCE.name(), maxPartitionsPerInstance);
        }
        if (instanceGroupTag != null) {
            this._record.setSimpleField(ResourceConfigProperty.INSTANCE_GROUP_TAG.name(), instanceGroupTag);
        }
        if (helixEnabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.HELIX_ENABLED.name(), helixEnabled);
        }
        if (resourceGroupName != null) {
            this._record.setSimpleField(ResourceConfigProperty.RESOURCE_GROUP_NAME.name(), resourceGroupName);
        }
        if (resourceType != null) {
            this._record.setSimpleField(ResourceConfigProperty.RESOURCE_TYPE.name(), resourceType);
        }
        if (groupRoutingEnabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.GROUP_ROUTING_ENABLED.name(), groupRoutingEnabled);
        }
        if (externalViewDisabled != null) {
            this._record.setBooleanField(ResourceConfigProperty.EXTERNAL_VIEW_DISABLED.name(), externalViewDisabled);
        }
        if (rebalanceConfig != null) {
            this.putSimpleConfigs(rebalanceConfig.getConfigsMap());
        }
        if (stateTransitionTimeoutConfig != null) {
            this.putMapConfig(StateTransitionTimeoutConfig.StateTransitionTimeoutProperty.TIMEOUT.name(), stateTransitionTimeoutConfig.getTimeoutMap());
        }
        if (listFields != null) {
            this._record.setListFields(listFields);
        }
        if (mapFields != null) {
            this._record.setMapFields(mapFields);
        }
        if (partitionCapacityMap != null) {
            try {
                this.setPartitionCapacityMap(partitionCapacityMap);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to set partition capacity. Invalid capacity configuration.");
            }
        }
    }

    public Boolean isMonitoringDisabled() {
        return this._record.getBooleanField(ResourceConfigProperty.MONITORING_DISABLED.toString(), false);
    }

    public boolean isP2PMessageEnabled() {
        return this._record.getBooleanField(HelixConfigProperty.P2P_MESSAGE_ENABLED.name(), false);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    public int getNumPartitions() {
        return this._record.getIntField(ResourceConfigProperty.NUM_PARTITIONS.name(), 0);
    }

    public String getStateModelDefRef() {
        return this._record.getSimpleField(ResourceConfigProperty.STATE_MODEL_DEF_REF.name());
    }

    public String getStateModelFactoryName() {
        return this._record.getSimpleField(ResourceConfigProperty.STATE_MODEL_FACTORY_NAME.name());
    }

    public String getNumReplica() {
        return this._record.getSimpleField(ResourceConfigProperty.REPLICAS.name());
    }

    public int getMinActiveReplica() {
        return this._record.getIntField(ResourceConfigProperty.MIN_ACTIVE_REPLICAS.name(), -1);
    }

    public int getMaxPartitionsPerInstance() {
        return this._record.getIntField(ResourceConfigProperty.MAX_PARTITIONS_PER_INSTANCE.toString(), Integer.MAX_VALUE);
    }

    public String getInstanceGroupTag() {
        return this._record.getSimpleField(ResourceConfigProperty.INSTANCE_GROUP_TAG.toString());
    }

    public Boolean isEnabled() {
        return this._record.getBooleanField(ResourceConfigProperty.HELIX_ENABLED.name(), true);
    }

    public String getResourceType() {
        return this._record.getSimpleField(ResourceConfigProperty.RESOURCE_TYPE.name());
    }

    public String getResourceGroupName() {
        return this._record.getSimpleField(ResourceConfigProperty.RESOURCE_GROUP_NAME.name());
    }

    public Boolean isGroupRoutingEnabled() {
        return this._record.getBooleanField(ResourceConfigProperty.GROUP_ROUTING_ENABLED.name(), false);
    }

    public Boolean isExternalViewDisabled() {
        return this._record.getBooleanField(ResourceConfigProperty.EXTERNAL_VIEW_DISABLED.name(), false);
    }

    public RebalanceConfig getRebalanceConfig() {
        RebalanceConfig rebalanceConfig = new RebalanceConfig(this._record);
        return rebalanceConfig;
    }

    public StateTransitionTimeoutConfig getStateTransitionTimeoutConfig() {
        return StateTransitionTimeoutConfig.fromRecord(this._record);
    }

    public Map<String, List<String>> getPreferenceLists() {
        return this._record.getListFields();
    }

    public List<String> getPreferenceList(String partitionName) {
        List<String> instanceStateList = this._record.getListField(partitionName);
        if (instanceStateList != null) {
            return instanceStateList;
        }
        return null;
    }

    public void setPreferenceLists(Map<String, List<String>> instanceLists) {
        this._record.setListFields(instanceLists);
    }

    public Map<String, Map<String, Integer>> getPartitionCapacityMap() throws IOException {
        if (this._deserializedPartitionCapacityMap != null && !this._deserializedPartitionCapacityMap.isEmpty()) {
            return this._deserializedPartitionCapacityMap;
        }
        Map<String, String> partitionCapacityData = this._record.getMapField(ResourceConfigProperty.PARTITION_CAPACITY_MAP.name());
        HashMap<String, Map<String, Integer>> partitionCapacityMap = new HashMap<String, Map<String, Integer>>();
        if (partitionCapacityData != null) {
            for (String partition : partitionCapacityData.keySet()) {
                Map capacities = (Map)_objectMapper.readValue(partitionCapacityData.get(partition), (TypeReference)new TypeReference<Map<String, Integer>>(){});
                partitionCapacityMap.put(partition, capacities);
            }
        }
        this._deserializedPartitionCapacityMap = partitionCapacityMap;
        return this._deserializedPartitionCapacityMap;
    }

    public void setPartitionCapacityMap(Map<String, Map<String, Integer>> partitionCapacityMap) throws IllegalArgumentException, IOException {
        if (partitionCapacityMap == null) {
            throw new IllegalArgumentException("Capacity Map is null");
        }
        if (!partitionCapacityMap.containsKey(DEFAULT_PARTITION_KEY)) {
            throw new IllegalArgumentException(String.format("The default partition capacity with the default key %s is required.", DEFAULT_PARTITION_KEY));
        }
        HashMap<String, String> newCapacityRecord = new HashMap<String, String>();
        HashMap<String, Map<String, Integer>> newDeserializedPartitionCapacityMap = new HashMap<String, Map<String, Integer>>();
        for (String partition : partitionCapacityMap.keySet()) {
            Map<String, Integer> capacities = partitionCapacityMap.get(partition);
            if (capacities.isEmpty()) {
                throw new IllegalArgumentException("Capacity Data is empty");
            }
            if (capacities.entrySet().stream().anyMatch(entry -> (Integer)entry.getValue() < 0)) {
                throw new IllegalArgumentException(String.format("Capacity Data contains a negative value:%s", capacities.toString()));
            }
            newCapacityRecord.put(partition, _objectMapper.writeValueAsString(capacities));
            newDeserializedPartitionCapacityMap.put(partition, (Map<String, Integer>)ImmutableMap.copyOf(capacities));
        }
        this._record.setMapField(ResourceConfigProperty.PARTITION_CAPACITY_MAP.name(), newCapacityRecord);
        this._deserializedPartitionCapacityMap = newDeserializedPartitionCapacityMap;
    }

    public void putSimpleConfigs(Map<String, String> configsMap) {
        this.getRecord().getSimpleFields().putAll(configsMap);
    }

    public Map<String, String> getSimpleConfigs() {
        return Collections.unmodifiableMap(this.getRecord().getSimpleFields());
    }

    public void putSimpleConfig(String configKey, String configVal) {
        this.getRecord().getSimpleFields().put(configKey, configVal);
    }

    public String getSimpleConfig(String configKey) {
        return this.getRecord().getSimpleFields().get(configKey);
    }

    public void putMapConfig(String configKey, Map<String, String> configValMap) {
        this.getRecord().setMapField(configKey, configValMap);
    }

    public Map<String, String> getMapConfig(String configKey) {
        return this.getRecord().getMapField(configKey);
    }

    public boolean simpleConfigContains(String configKey) {
        return this.getRecord().getSimpleFields().containsKey(configKey);
    }

    public boolean mapConfigContains(String configKey) {
        return this.getRecord().getMapFields().containsKey(configKey);
    }

    public Map<String, Map<String, String>> getMapConfigs() {
        return this.getRecord().getMapFields();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ResourceConfig) {
            ResourceConfig that = (ResourceConfig)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static ResourceConfig mergeIdealStateWithResourceConfig(ResourceConfig resourceConfig, IdealState idealState) {
        ResourceConfig mergedResourceConfig;
        if (idealState == null) {
            return resourceConfig;
        }
        if (resourceConfig != null) {
            if (!resourceConfig.getResourceName().equals(idealState.getResourceName())) {
                throw new IllegalArgumentException(String.format("Cannot merge the IdealState of resource %s with the ResourceConfig of resource %s", resourceConfig.getResourceName(), idealState.getResourceName()));
            }
            mergedResourceConfig = new ResourceConfig(resourceConfig.getRecord());
        } else {
            mergedResourceConfig = new ResourceConfig(idealState.getResourceName());
        }
        ZNRecord mergedZNRecord = mergedResourceConfig.getRecord();
        mergedZNRecord.setSimpleFieldIfAbsent(ResourceConfigProperty.INSTANCE_GROUP_TAG.name(), idealState.getInstanceGroupTag());
        mergedZNRecord.setIntFieldIfAbsent(ResourceConfigProperty.MAX_PARTITIONS_PER_INSTANCE.name(), idealState.getMaxPartitionsPerInstance());
        mergedZNRecord.setIntFieldIfAbsent(ResourceConfigProperty.NUM_PARTITIONS.name(), idealState.getNumPartitions());
        mergedZNRecord.setSimpleFieldIfAbsent(ResourceConfigProperty.STATE_MODEL_DEF_REF.name(), idealState.getStateModelDefRef());
        mergedZNRecord.setSimpleFieldIfAbsent(ResourceConfigProperty.STATE_MODEL_FACTORY_NAME.name(), idealState.getStateModelFactoryName());
        mergedZNRecord.setSimpleFieldIfAbsent(ResourceConfigProperty.REPLICAS.name(), idealState.getReplicas());
        mergedZNRecord.setIntFieldIfAbsent(ResourceConfigProperty.MIN_ACTIVE_REPLICAS.name(), idealState.getMinActiveReplicas());
        mergedZNRecord.setBooleanFieldIfAbsent(ResourceConfigProperty.HELIX_ENABLED.name(), idealState.isEnabled());
        mergedZNRecord.setSimpleFieldIfAbsent(ResourceConfigProperty.RESOURCE_GROUP_NAME.name(), idealState.getResourceGroupName());
        mergedZNRecord.setSimpleFieldIfAbsent(ResourceConfigProperty.RESOURCE_TYPE.name(), idealState.getResourceType());
        mergedZNRecord.setBooleanFieldIfAbsent(ResourceConfigProperty.EXTERNAL_VIEW_DISABLED.name(), idealState.isExternalViewDisabled());
        mergedZNRecord.setBooleanFieldIfAbsent(ResourceConfigProperty.DELAY_REBALANCE_ENABLED.name(), idealState.isDelayRebalanceEnabled());
        return mergedResourceConfig;
    }

    public static class Builder {
        private String _resourceId;
        private Boolean _monitorDisabled;
        private int _numPartitions;
        private String _stateModelDefRef;
        private String _stateModelFactoryName;
        private String _numReplica;
        private int _minActiveReplica = -1;
        private int _maxPartitionsPerInstance = -1;
        private String _instanceGroupTag;
        private Boolean _helixEnabled;
        private String _resourceGroupName;
        private String _resourceType;
        private Boolean _groupRoutingEnabled;
        private Boolean _externalViewDisabled;
        private Boolean _p2pMessageEnabled;
        private RebalanceConfig _rebalanceConfig;
        private StateTransitionTimeoutConfig _stateTransitionTimeoutConfig;
        private Map<String, List<String>> _preferenceLists;
        private Map<String, Map<String, String>> _mapFields;
        private Map<String, Map<String, Integer>> _partitionCapacityMap;

        public Builder(String resourceId) {
            this._resourceId = resourceId;
        }

        public Builder setMonitorDisabled(boolean monitorDisabled) {
            this._monitorDisabled = monitorDisabled;
            return this;
        }

        public Builder setP2PMessageEnabled(boolean enabled) {
            this._p2pMessageEnabled = enabled;
            return this;
        }

        public Boolean isMonitorDisabled() {
            return this._monitorDisabled;
        }

        public String getResourceId() {
            return this._resourceId;
        }

        public int getNumPartitions() {
            return this._numPartitions;
        }

        public Builder setNumPartitions(int numPartitions) {
            this._numPartitions = numPartitions;
            return this;
        }

        public String getStateModelDefRef() {
            return this._stateModelDefRef;
        }

        public Builder setStateModelDefRef(String stateModelDefRef) {
            this._stateModelDefRef = stateModelDefRef;
            return this;
        }

        public String getStateModelFactoryName() {
            return this._stateModelFactoryName;
        }

        public Builder setStateModelFactoryName(String stateModelFactoryName) {
            this._stateModelFactoryName = stateModelFactoryName;
            return this;
        }

        public String getNumReplica() {
            return this._numReplica;
        }

        public Builder setNumReplica(String numReplica) {
            this._numReplica = numReplica;
            return this;
        }

        public Builder setNumReplica(int numReplica) {
            return this.setNumReplica(String.valueOf(numReplica));
        }

        public int getMinActiveReplica() {
            return this._minActiveReplica;
        }

        public Builder setMinActiveReplica(int minActiveReplica) {
            this._minActiveReplica = minActiveReplica;
            return this;
        }

        public int getMaxPartitionsPerInstance() {
            return this._maxPartitionsPerInstance;
        }

        public Builder setMaxPartitionsPerInstance(int maxPartitionsPerInstance) {
            this._maxPartitionsPerInstance = maxPartitionsPerInstance;
            return this;
        }

        public String getInstanceGroupTag() {
            return this._instanceGroupTag;
        }

        public Builder setInstanceGroupTag(String instanceGroupTag) {
            this._instanceGroupTag = instanceGroupTag;
            return this;
        }

        public Boolean isHelixEnabled() {
            return this._helixEnabled;
        }

        public Builder setHelixEnabled(boolean helixEnabled) {
            this._helixEnabled = helixEnabled;
            return this;
        }

        public String getResourceType() {
            return this._resourceType;
        }

        public Builder setResourceType(String resourceType) {
            this._resourceType = resourceType;
            return this;
        }

        public String getResourceGroupName() {
            return this._resourceGroupName;
        }

        public Builder setResourceGroupName(String resourceGroupName) {
            this._resourceGroupName = resourceGroupName;
            return this;
        }

        public Boolean isGroupRoutingEnabled() {
            return this._groupRoutingEnabled;
        }

        public Builder setGroupRoutingEnabled(boolean groupRoutingEnabled) {
            this._groupRoutingEnabled = groupRoutingEnabled;
            return this;
        }

        public Boolean isExternalViewDisabled() {
            return this._externalViewDisabled;
        }

        public Builder setExternalViewDisabled(boolean externalViewDisabled) {
            this._externalViewDisabled = externalViewDisabled;
            return this;
        }

        public Builder setRebalanceConfig(RebalanceConfig rebalanceConfig) {
            this._rebalanceConfig = rebalanceConfig;
            return this;
        }

        public RebalanceConfig getRebalanceConfig() {
            return this._rebalanceConfig;
        }

        public Builder setStateTransitionTimeoutConfig(StateTransitionTimeoutConfig stateTransitionTimeoutConfig) {
            this._stateTransitionTimeoutConfig = stateTransitionTimeoutConfig;
            return this;
        }

        public StateTransitionTimeoutConfig getStateTransitionTimeoutConfig() {
            return this._stateTransitionTimeoutConfig;
        }

        public Builder setPreferenceList(String partitionName, List<String> instanceList) {
            if (this._preferenceLists == null) {
                this._preferenceLists = new TreeMap<String, List<String>>();
            }
            this._preferenceLists.put(partitionName, instanceList);
            return this;
        }

        public Builder setPreferenceLists(Map<String, List<String>> instanceLists) {
            this._preferenceLists = new TreeMap<String, List<String>>(instanceLists);
            return this;
        }

        public Map<String, List<String>> getPreferenceLists() {
            return this._preferenceLists;
        }

        public Builder setPartitionCapacity(Map<String, Integer> defaultCapacity) {
            this.setPartitionCapacity(ResourceConfig.DEFAULT_PARTITION_KEY, defaultCapacity);
            return this;
        }

        public Builder setPartitionCapacity(String partition, Map<String, Integer> capacity) {
            if (this._partitionCapacityMap == null) {
                this._partitionCapacityMap = new HashMap<String, Map<String, Integer>>();
            }
            this._partitionCapacityMap.put(partition, capacity);
            return this;
        }

        public Map<String, Integer> getPartitionCapacity(String partition) {
            return this._partitionCapacityMap.get(partition);
        }

        public Builder setMapField(String key, Map<String, String> fields) {
            if (this._mapFields == null) {
                this._mapFields = new TreeMap<String, Map<String, String>>();
            }
            this._mapFields.put(key, fields);
            return this;
        }

        public Builder setMapFields(Map<String, Map<String, String>> mapFields) {
            this._mapFields = mapFields;
            return this;
        }

        public Map<String, Map<String, String>> getMapFields() {
            return this._mapFields;
        }

        private void validate() {
            if (this._rebalanceConfig == null) {
                throw new IllegalArgumentException("RebalanceConfig not set!");
            }
            if (!this._rebalanceConfig.isValid()) {
                throw new IllegalArgumentException("Invalid RebalanceConfig!");
            }
            if (this._numPartitions <= 0) {
                throw new IllegalArgumentException("Invalid number of partitions!");
            }
            if (this._stateModelDefRef == null) {
                throw new IllegalArgumentException("State Model Definition Reference is not set!");
            }
            if (this._numReplica == null) {
                throw new IllegalArgumentException("Number of replica is not set!");
            }
            if (!this._numReplica.equals(ResourceConfigConstants.ANY_LIVEINSTANCE.name())) {
                try {
                    Integer.parseInt(this._numReplica);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid number of replica!");
                }
            }
            if (this._partitionCapacityMap != null) {
                if (this._partitionCapacityMap.keySet().stream().noneMatch(partition -> partition.equals(ResourceConfig.DEFAULT_PARTITION_KEY))) {
                    throw new IllegalArgumentException("Partition capacity is configured without the DEFAULT capacity!");
                }
                if (this._partitionCapacityMap.values().stream().anyMatch(capacity -> capacity.values().stream().anyMatch(value -> value < 0))) {
                    throw new IllegalArgumentException("Partition capacity is configured with negative capacity value!");
                }
            }
        }

        public ResourceConfig build() {
            return new ResourceConfig(this._resourceId, this._monitorDisabled, this._numPartitions, this._stateModelDefRef, this._stateModelFactoryName, this._numReplica, this._minActiveReplica, this._maxPartitionsPerInstance, this._instanceGroupTag, this._helixEnabled, this._resourceGroupName, this._resourceType, this._groupRoutingEnabled, this._externalViewDisabled, this._rebalanceConfig, this._stateTransitionTimeoutConfig, this._preferenceLists, this._mapFields, this._p2pMessageEnabled, this._partitionCapacityMap);
        }
    }

    public static enum ResourceConfigConstants {
        ANY_LIVEINSTANCE;

    }

    public static enum ResourceConfigProperty {
        MONITORING_DISABLED,
        NUM_PARTITIONS,
        STATE_MODEL_DEF_REF,
        STATE_MODEL_FACTORY_NAME,
        REPLICAS,
        MIN_ACTIVE_REPLICAS,
        MAX_PARTITIONS_PER_INSTANCE,
        INSTANCE_GROUP_TAG,
        HELIX_ENABLED,
        RESOURCE_GROUP_NAME,
        RESOURCE_TYPE,
        GROUP_ROUTING_ENABLED,
        EXTERNAL_VIEW_DISABLED,
        DELAY_REBALANCE_ENABLED,
        PARTITION_CAPACITY_MAP;

    }
}

