/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.view.monitoring;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.helix.monitoring.mbeans.MBeanRegistrar;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class ViewAggregatorMonitor
extends DynamicMBeanProvider {
    static final String MBEAN_DOMAIN = MonitorDomainNames.ClusterStatus.name();
    static final String MONITOR_KEY = "ViewClusterName";
    private static final String MBEAN_DESCRIPTION = "Monitor helix view aggregator activity";
    private final String _clusterName;
    private final String _sensorName;
    private final SimpleDynamicMetric<Long> _refreshViewFailureCounter;
    private final SimpleDynamicMetric<Long> _sourceReadFailureCounter;
    private final SimpleDynamicMetric<Long> _processViewConfigFailureCounter;
    private final SimpleDynamicMetric<Long> _processedSourceClusterEventCounter;
    private final HistogramDynamicMetric _viewRefreshLatencyGauge;

    public ViewAggregatorMonitor(String clusterName) {
        this._clusterName = clusterName;
        this._sensorName = String.format("%s.%s.%s", MBEAN_DOMAIN, MONITOR_KEY, clusterName);
        this._refreshViewFailureCounter = new SimpleDynamicMetric("ViewClusterRefreshFailureCounter", (Object)0L);
        this._sourceReadFailureCounter = new SimpleDynamicMetric("SourceClusterRefreshFailureCounter", (Object)0L);
        this._processedSourceClusterEventCounter = new SimpleDynamicMetric("ProcessedSourceClusterEventCounter", (Object)0L);
        this._processViewConfigFailureCounter = new SimpleDynamicMetric("ProcessViewConfigFailureCounter", (Object)0L);
        this._viewRefreshLatencyGauge = new HistogramDynamicMetric("ViewClusterRefreshDurationGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(60000L, TimeUnit.MILLISECONDS)));
    }

    public void recordViewRefreshFailure() {
        this._refreshViewFailureCounter.updateValue((Object)((Long)this._refreshViewFailureCounter.getValue() + 1L));
    }

    public void recordViewConfigProcessFailure() {
        this._processViewConfigFailureCounter.updateValue((Object)((Long)this._processViewConfigFailureCounter.getValue() + 1L));
    }

    public void recordReadSourceFailure() {
        this._sourceReadFailureCounter.updateValue((Object)((Long)this._sourceReadFailureCounter.getValue() + 1L));
    }

    public void recordProcessedSourceEvent() {
        this._processedSourceClusterEventCounter.updateValue((Object)((Long)this._processedSourceClusterEventCounter.getValue() + 1L));
    }

    public void recordRefreshViewLatency(long latency) {
        this._viewRefreshLatencyGauge.updateValue(Long.valueOf(latency));
    }

    public String getSensorName() {
        return this._sensorName;
    }

    public DynamicMBeanProvider register() throws JMException {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        attributeList.add(this._sourceReadFailureCounter);
        attributeList.add(this._refreshViewFailureCounter);
        attributeList.add(this._processViewConfigFailureCounter);
        attributeList.add(this._processedSourceClusterEventCounter);
        attributeList.add(this._viewRefreshLatencyGauge);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, MBeanRegistrar.buildObjectName((String)MBEAN_DOMAIN, (String[])new String[]{MONITOR_KEY, this._clusterName}));
        return this;
    }
}

