/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.LinkedHashMap;
import org.apache.helix.HelixException;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.model.ClusterConfig;

public class ClusterTopologyConfig {
    private static final String DEFAULT_DOMAIN_PREFIX = "Helix_default_";
    private static final String TOPOLOGY_SPLITTER = "/";
    private final boolean _topologyAwareEnabled;
    private final String _endNodeType;
    private final String _faultZoneType;
    private final LinkedHashMap<String, String> _topologyKeyDefaultValue;

    private ClusterTopologyConfig(boolean topologyAwareEnabled, String endNodeType, String faultZoneType, LinkedHashMap<String, String> topologyKeyDefaultValue) {
        this._topologyAwareEnabled = topologyAwareEnabled;
        this._endNodeType = endNodeType;
        this._faultZoneType = faultZoneType;
        this._topologyKeyDefaultValue = topologyKeyDefaultValue;
    }

    public static ClusterTopologyConfig createFromClusterConfig(ClusterConfig clusterConfig) {
        if (!clusterConfig.isTopologyAwareEnabled()) {
            return new ClusterTopologyConfig(false, Topology.Types.INSTANCE.name(), Topology.Types.INSTANCE.name(), new LinkedHashMap<String, String>());
        }
        String endNodeType = Topology.Types.INSTANCE.name();
        String faultZoneType = Topology.Types.ZONE.name();
        LinkedHashMap<String, String> topologyKeyDefaultValue = new LinkedHashMap<String, String>();
        String topologyDef = clusterConfig.getTopology();
        if (topologyDef != null) {
            for (String topologyKey : topologyDef.trim().split(TOPOLOGY_SPLITTER)) {
                if (topologyKey.isEmpty()) continue;
                topologyKeyDefaultValue.put(topologyKey, DEFAULT_DOMAIN_PREFIX + topologyKey);
                endNodeType = topologyKey;
            }
            if (topologyKeyDefaultValue.isEmpty()) {
                throw new IllegalArgumentException("Invalid cluster topology definition " + topologyDef);
            }
            faultZoneType = clusterConfig.getFaultZoneType();
            if (faultZoneType == null) {
                faultZoneType = endNodeType;
            } else if (!topologyKeyDefaultValue.containsKey(faultZoneType)) {
                throw new HelixException(String.format("Invalid fault zone type %s, not present in topology definition %s.", faultZoneType, clusterConfig.getTopology()));
            }
        }
        return new ClusterTopologyConfig(true, endNodeType, faultZoneType, topologyKeyDefaultValue);
    }

    public boolean isTopologyAwareEnabled() {
        return this._topologyAwareEnabled;
    }

    public String getEndNodeType() {
        return this._endNodeType;
    }

    public String getFaultZoneType() {
        return this._faultZoneType;
    }

    public LinkedHashMap<String, String> getTopologyKeyDefaultValue() {
        return this._topologyKeyDefaultValue;
    }
}

