/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerResource.class);

    public ControllerResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    StringRepresentation getControllerRepresentation(String clusterName) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
        ZNRecord record = null;
        LiveInstance leader = (LiveInstance)accessor.getProperty(keyBuilder.controllerLeader());
        if (leader != null) {
            record = leader.getRecord();
        } else {
            record = new ZNRecord("");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss.SSSSSS");
            String time = formatter.format(new Date());
            TreeMap<String, String> contentMap = new TreeMap<String, String>();
            contentMap.put("AdditionalInfo", "No leader exists");
            record.setMapField(StatusUpdateUtil.Level.HELIX_INFO + "-" + time, contentMap);
        }
        boolean paused = accessor.getProperty(keyBuilder.pause()) != null;
        record.setSimpleField(PropertyType.PAUSE.toString(), "" + paused);
        String retVal = ClusterRepresentationUtil.ZNRecordToJson(record);
        StringRepresentation representation = new StringRepresentation((CharSequence)retVal, MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            presentation = this.getControllerRepresentation(clusterName);
        }
        catch (Exception e) {
            LOG.error("Exception get controller info", (Throwable)e);
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
        }
        return presentation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (command == null) {
                throw new HelixException("Could NOT find 'command' in parameterMap: " + jsonParameters._parameterMap);
            }
            if (!command.equalsIgnoreCase("enableCluster")) {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [enableCluster]");
            }
            boolean enabled = Boolean.parseBoolean(jsonParameters.getParameter("enabled"));
            setupTool.getClusterManagementTool().enableCluster(clusterName, enabled);
            this.getResponse().setEntity((Representation)this.getControllerRepresentation(clusterName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        return null;
    }
}

