/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.dataproviders;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.common.caches.TaskDataCache;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowControllerDataProvider
extends BaseControllerDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowControllerDataProvider.class);
    private static final String PIPELINE_NAME = Pipeline.Type.TASK.name();
    private TaskDataCache _taskDataCache;
    private Map<String, Integer> _participantActiveTaskCount = new HashMap<String, Integer>();
    private boolean _existsLiveInstanceOrCurrentStateOrMessageChange = false;

    public WorkflowControllerDataProvider() {
        this("UNKNOWN_CLUSTER");
    }

    public WorkflowControllerDataProvider(String clusterName) {
        super(clusterName, PIPELINE_NAME);
        this._taskDataCache = new TaskDataCache(this);
    }

    private void refreshClusterStateChangeFlags(Set<HelixConstants.ChangeType> propertyRefreshed) {
        this._existsLiveInstanceOrCurrentStateOrMessageChange = ((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CURRENT_STATE)).getAndSet(false) || ((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.TASK_CURRENT_STATE)).getAndSet(false) || ((AtomicBoolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.MESSAGE)).getAndSet(false) || propertyRefreshed.contains((Object)HelixConstants.ChangeType.LIVE_INSTANCE);
    }

    @Override
    public synchronized void refresh(HelixDataAccessor accessor) {
        long startTime = System.currentTimeMillis();
        Set<HelixConstants.ChangeType> propertyRefreshed = super.doRefresh(accessor);
        this._taskCurrentStateCache.refresh(accessor, this.getLiveInstanceCache().getPropertyMap());
        this.refreshClusterStateChangeFlags(propertyRefreshed);
        this._taskDataCache.refresh(accessor, this.getResourceConfigMap());
        long duration = System.currentTimeMillis() - startTime;
        LogUtil.logInfo(logger, this.getClusterEventId(), String.format("END: WorkflowControllerDataProvider.refresh() for cluster %s, started at %d took %d for %s pipeline", this.getClusterName(), startTime, duration, this.getPipelineName()));
        this.dumpDebugInfo();
    }

    @Override
    protected void dumpDebugInfo() {
        super.dumpDebugInfo();
        LogUtil.logDebug(logger, this.getClusterEventId(), "JobContexts: " + this._taskDataCache.getContexts().keySet());
        if (logger.isTraceEnabled()) {
            logger.trace("Cache content: " + this.toString());
        }
    }

    @Override
    public synchronized void setLiveInstances(List<LiveInstance> liveInstances) {
        this._existsLiveInstanceOrCurrentStateOrMessageChange = true;
        super.setLiveInstances(liveInstances);
    }

    public Map<String, JobConfig> getJobConfigMap() {
        return this._taskDataCache.getJobConfigMap();
    }

    public JobConfig getJobConfig(String resource) {
        return this._taskDataCache.getJobConfig(resource);
    }

    public Map<String, WorkflowConfig> getWorkflowConfigMap() {
        return this._taskDataCache.getWorkflowConfigMap();
    }

    public WorkflowConfig getWorkflowConfig(String resource) {
        return this._taskDataCache.getWorkflowConfig(resource);
    }

    public Integer getParticipantActiveTaskCount(String instance) {
        return this._participantActiveTaskCount.get(instance);
    }

    public void setParticipantActiveTaskCount(String instance, int taskCount) {
        this._participantActiveTaskCount.put(instance, taskCount);
    }

    public void resetActiveTaskCount(CurrentStateOutput currentStateOutput) {
        for (String liveInstance : this.getLiveInstances().keySet()) {
            this._participantActiveTaskCount.put(liveInstance, 0);
        }
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithPendingState("Task", TaskPartitionState.INIT.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithPendingState("Task", TaskPartitionState.RUNNING.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithCurrentState("Task", TaskPartitionState.INIT.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithCurrentState("Task", TaskPartitionState.RUNNING.name()), this._participantActiveTaskCount);
    }

    private void fillActiveTaskCount(Map<String, Integer> additionPartitionMap, Map<String, Integer> partitionMap) {
        for (String participant : additionPartitionMap.keySet()) {
            partitionMap.put(participant, partitionMap.get(participant) + additionPartitionMap.get(participant));
        }
    }

    public JobContext getJobContext(String resourceName) {
        return this._taskDataCache.getJobContext(resourceName);
    }

    public WorkflowContext getWorkflowContext(String resourceName) {
        return this._taskDataCache.getWorkflowContext(resourceName);
    }

    public void updateJobContext(String resourceName, JobContext jobContext) {
        this._taskDataCache.updateJobContext(resourceName, jobContext);
    }

    public void updateWorkflowContext(String resourceName, WorkflowContext workflowContext) {
        this._taskDataCache.updateWorkflowContext(resourceName, workflowContext);
    }

    public TaskDataCache getTaskDataCache() {
        return this._taskDataCache;
    }

    public Map<String, ZNRecord> getContexts() {
        return this._taskDataCache.getContexts();
    }

    public AssignableInstanceManager getAssignableInstanceManager() {
        return this._taskDataCache.getAssignableInstanceManager();
    }

    public boolean getExistsLiveInstanceOrCurrentStateOrMessageChange() {
        return this._existsLiveInstanceOrCurrentStateOrMessageChange;
    }

    public Map<String, CurrentState> getTaskCurrentState(String instanceName, String clientSessionId) {
        return this._taskCurrentStateCache.getParticipantState(instanceName, clientSessionId);
    }

    @Override
    public String toString() {
        StringBuilder sb = this.genCacheContentStringBuilder();
        sb.append(String.format("taskDataCache: %s", this._taskDataCache)).append("\n");
        return sb.toString();
    }
}

