/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.json.instance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StoppableCheck {
    @JsonProperty(value="stoppable")
    private boolean isStoppable;
    @JsonProperty(value="failedChecks")
    private List<String> failedChecks;

    public StoppableCheck(boolean isStoppable, List<String> failedChecks, Category category) {
        this.isStoppable = isStoppable;
        this.failedChecks = failedChecks.stream().sorted().map(checkName -> this.appendPrefix((String)checkName, category)).collect(Collectors.toList());
    }

    public StoppableCheck(Map<String, Boolean> checks, Category category) {
        this.failedChecks = Maps.filterValues(checks, Boolean.FALSE::equals).keySet().stream().sorted().map(checkName -> this.appendPrefix((String)checkName, category)).collect(Collectors.toList());
        this.isStoppable = this.failedChecks.isEmpty();
    }

    private String appendPrefix(String checkName, Category category) {
        return category.prefix + checkName;
    }

    public boolean isStoppable() {
        return this.isStoppable;
    }

    public List<String> getFailedChecks() {
        return this.failedChecks;
    }

    public static enum Category {
        HELIX_OWN_CHECK("Helix:"),
        CUSTOM_INSTANCE_CHECK("CustomInstance:"),
        CUSTOM_PARTITION_CHECK("CustomPartition:");

        String prefix;

        private Category(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

