/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.MemoryUtils;

public abstract class ConcurrentArrayBlockingQueue<E>
extends ConcurrentArrayQueue<E>
implements BlockingQueue<E> {
    private final Lock _lock = new ReentrantLock();
    private final Condition _consumer = this._lock.newCondition();

    public ConcurrentArrayBlockingQueue(int blockSize) {
        super(blockSize);
    }

    @Override
    public E poll() {
        Object result = super.poll();
        if (result != null && this.decrementAndGetSize() > 0) {
            this.signalConsumer();
        }
        return (E)result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result && this.decrementAndGetSize() > 0) {
            this.signalConsumer();
        }
        return result;
    }

    protected abstract int decrementAndGetSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalConsumer() {
        Lock lock = this._lock;
        lock.lock();
        try {
            this._consumer.signal();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E result;
        while ((result = this.poll()) == null) {
            Lock lock = this._lock;
            lock.lockInterruptibly();
            try {
                if (this.size() != 0) continue;
                this._consumer.await();
                continue;
            }
            finally {
                lock.unlock();
                continue;
            }
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        E result;
        while ((result = this.poll()) == null) {
            Lock lock = this._lock;
            lock.lockInterruptibly();
            try {
                if (this.size() != 0) continue;
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this._consumer.awaitNanos(nanos);
                continue;
            }
            finally {
                lock.unlock();
                continue;
            }
            break;
        }
        return result;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E element;
        int added;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (added = 0; added < maxElements && (element = this.poll()) != null; ++added) {
            c.add(element);
        }
        return added;
    }

    public static class Bounded<E>
    extends ConcurrentArrayBlockingQueue<E> {
        private final AtomicInteger _size = new AtomicInteger();
        private final Lock _lock = new ReentrantLock();
        private final Condition _producer = this._lock.newCondition();
        private final int _capacity;

        public Bounded(int capacity) {
            this(512, capacity);
        }

        public Bounded(int blockSize, int capacity) {
            super(blockSize);
            this._capacity = capacity;
        }

        @Override
        public boolean offer(E item) {
            int size;
            int nextSize;
            while ((nextSize = (size = this.size()) + 1) <= this._capacity) {
                if (!this._size.compareAndSet(size, nextSize)) continue;
                if (super.offer(item)) {
                    if (size == 0) {
                        this.signalConsumer();
                    }
                    return true;
                }
                this.decrementAndGetSize();
            }
            return false;
        }

        @Override
        public E poll() {
            Object result = super.poll();
            if (result != null) {
                this.signalProducer();
            }
            return result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result = super.remove(o);
            if (result) {
                this.signalProducer();
            }
            return result;
        }

        @Override
        protected int decrementAndGetSize() {
            return this._size.decrementAndGet();
        }

        @Override
        public int size() {
            return this._size.get();
        }

        @Override
        public int remainingCapacity() {
            return this._capacity - this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(E item) throws InterruptedException {
            item = Objects.requireNonNull(item);
            do {
                Lock lock = this._lock;
                lock.lockInterruptibly();
                try {
                    if (this.size() != this._capacity) continue;
                    this._producer.await();
                }
                finally {
                    lock.unlock();
                }
            } while (!this.offer(item));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(E item, long timeout, TimeUnit unit) throws InterruptedException {
            item = Objects.requireNonNull(item);
            long nanos = unit.toNanos(timeout);
            do {
                Lock lock = this._lock;
                lock.lockInterruptibly();
                try {
                    if (this.size() != this._capacity) continue;
                    if (nanos <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    nanos = this._producer.awaitNanos(nanos);
                }
                finally {
                    lock.unlock();
                }
            } while (!this.offer(item));
            return true;
        }

        @Override
        public int drainTo(Collection<? super E> c, int maxElements) {
            int result = super.drainTo(c, maxElements);
            if (result > 0) {
                this.signalProducers();
            }
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            this.signalProducers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalProducer() {
            Lock lock = this._lock;
            lock.lock();
            try {
                this._producer.signal();
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalProducers() {
            Lock lock = this._lock;
            lock.lock();
            try {
                this._producer.signalAll();
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static class Unbounded<E>
    extends ConcurrentArrayBlockingQueue<E> {
        private static final int SIZE_LEFT_OFFSET = MemoryUtils.getLongsPerCacheLine() - 1;
        private static final int SIZE_RIGHT_OFFSET = SIZE_LEFT_OFFSET + MemoryUtils.getLongsPerCacheLine();
        private final AtomicLongArray _sizes = new AtomicLongArray(SIZE_RIGHT_OFFSET + 1);

        public Unbounded() {
            this(512);
        }

        public Unbounded(int blockSize) {
            super(blockSize);
        }

        @Override
        public boolean offer(E item) {
            boolean result = super.offer(item);
            if (result && this.getAndIncrementSize() == 0) {
                this.signalConsumer();
            }
            return result;
        }

        private int getAndIncrementSize() {
            long sizeRight = this._sizes.getAndIncrement(SIZE_RIGHT_OFFSET);
            long sizeLeft = this._sizes.get(SIZE_LEFT_OFFSET);
            return (int)(sizeRight - sizeLeft);
        }

        @Override
        protected int decrementAndGetSize() {
            long sizeLeft = this._sizes.incrementAndGet(SIZE_LEFT_OFFSET);
            long sizeRight = this._sizes.get(SIZE_RIGHT_OFFSET);
            return (int)(sizeRight - sizeLeft);
        }

        @Override
        public int size() {
            long sizeLeft = this._sizes.get(SIZE_LEFT_OFFSET);
            long sizeRight = this._sizes.get(SIZE_RIGHT_OFFSET);
            return (int)(sizeRight - sizeLeft);
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void put(E element) throws InterruptedException {
            this.offer(element);
        }

        @Override
        public boolean offer(E element, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(element);
        }
    }
}

