/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.commandtools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.model.IdealState;
import org.apache.helix.util.HelixUtil;

public class ZkLogCSVFormatter {
    private static final ZNRecordSerializer _deserializer = new ZNRecordSerializer();
    private static String _fieldDelim = ",";

    public static void main(String[] args) throws Exception {
        File outputDir;
        if (args.length != 2) {
            System.err.println("USAGE: ZkLogCSVFormatter log_file output_dir");
            System.exit(2);
        }
        if (!(outputDir = new File(args[1])).exists() || !outputDir.isDirectory()) {
            System.err.println(outputDir.getAbsolutePath() + " does NOT exist or is NOT a directory");
            System.exit(2);
        }
        ZkLogCSVFormatter.format(args[0], args[1]);
    }

    private static void formatter(BufferedWriter bw, String ... args) {
        StringBuffer sb = new StringBuffer();
        if (args.length == 0) {
            return;
        }
        sb.append(args[0]);
        for (int i = 1; i < args.length; ++i) {
            sb.append(_fieldDelim).append(args[i]);
        }
        try {
            bw.write(sb.toString());
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getAttributeValue(String line, String attribute) {
        String[] parts = line.split("\\s");
        if (parts != null && parts.length > 0) {
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].startsWith(attribute)) continue;
                String val = parts[i].substring(attribute.length());
                return val;
            }
        }
        return null;
    }

    private static void format(String logfilepath, String outputDir) throws FileNotFoundException {
        try {
            String inputLine;
            FileInputStream fis = new FileInputStream(logfilepath);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            FileOutputStream isFos = new FileOutputStream(outputDir + "/" + "idealState.csv");
            BufferedWriter isBw = new BufferedWriter(new OutputStreamWriter(isFos));
            FileOutputStream cfgFos = new FileOutputStream(outputDir + "/" + "config.csv");
            BufferedWriter cfgBw = new BufferedWriter(new OutputStreamWriter(cfgFos));
            FileOutputStream evFos = new FileOutputStream(outputDir + "/" + "externalView.csv");
            BufferedWriter evBw = new BufferedWriter(new OutputStreamWriter(evFos));
            FileOutputStream smdCntFos = new FileOutputStream(outputDir + "/" + "stateModelDefStateCount.csv");
            BufferedWriter smdCntBw = new BufferedWriter(new OutputStreamWriter(smdCntFos));
            FileOutputStream smdNextFos = new FileOutputStream(outputDir + "/" + "stateModelDefStateNext.csv");
            BufferedWriter smdNextBw = new BufferedWriter(new OutputStreamWriter(smdNextFos));
            FileOutputStream csFos = new FileOutputStream(outputDir + "/" + "currentState.csv");
            BufferedWriter csBw = new BufferedWriter(new OutputStreamWriter(csFos));
            FileOutputStream msgFos = new FileOutputStream(outputDir + "/" + "messages.csv");
            BufferedWriter msgBw = new BufferedWriter(new OutputStreamWriter(msgFos));
            FileOutputStream hrPerfFos = new FileOutputStream(outputDir + "/" + "healthReportDefaultPerfCounters.csv");
            BufferedWriter hrPerfBw = new BufferedWriter(new OutputStreamWriter(hrPerfFos));
            FileOutputStream liFos = new FileOutputStream(outputDir + "/" + "liveInstances.csv");
            BufferedWriter liBw = new BufferedWriter(new OutputStreamWriter(liFos));
            ZkLogCSVFormatter.formatter(cfgBw, "timestamp", "instanceName", "host", "port", "enabled");
            ZkLogCSVFormatter.formatter(isBw, "timestamp", "resourceName", "partitionNumber", "mode", "partition", "instanceName", "priority");
            ZkLogCSVFormatter.formatter(evBw, "timestamp", "resourceName", "partition", "instanceName", "state");
            ZkLogCSVFormatter.formatter(smdCntBw, "timestamp", "stateModel", "state", "count");
            ZkLogCSVFormatter.formatter(smdNextBw, "timestamp", "stateModel", "from", "to", "next");
            ZkLogCSVFormatter.formatter(liBw, "timestamp", "instanceName", "sessionId", "Operation");
            ZkLogCSVFormatter.formatter(csBw, "timestamp", "resourceName", "partition", "instanceName", "sessionId", "state");
            ZkLogCSVFormatter.formatter(msgBw, "timestamp", "resourceName", "partition", "instanceName", "sessionId", "from", "to", "messageType", "messageState");
            ZkLogCSVFormatter.formatter(hrPerfBw, "timestamp", "instanceName", "availableCPUs", "averageSystemLoad", "freeJvmMemory", "freePhysicalMemory", "totalJvmMemory");
            HashMap<Object, ZNRecord> liveInstanceSessionMap = new HashMap<Object, ZNRecord>();
            while ((inputLine = br.readLine()) != null) {
                Map<String, String> stateMap;
                String instance2;
                ZNRecord record;
                String timestamp;
                int pos;
                if (inputLine.indexOf("CONFIGS") != -1) {
                    pos = inputLine.indexOf("CONFIGS");
                    if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                    timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                    ZkLogCSVFormatter.formatter(cfgBw, timestamp, record.getId(), record.getSimpleField("HOST"), record.getSimpleField("PORT"), record.getSimpleField("ENABLED"));
                    continue;
                }
                if (inputLine.indexOf("IDEALSTATES") != -1) {
                    pos = inputLine.indexOf("IDEALSTATES");
                    if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                    timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                    for (String partition : record.getListFields().keySet()) {
                        List<String> preferenceList = record.getListFields().get(partition);
                        for (int i = 0; i < preferenceList.size(); ++i) {
                            instance2 = preferenceList.get(i);
                            ZkLogCSVFormatter.formatter(isBw, timestamp, record.getId(), record.getSimpleField(IdealState.IdealStateProperty.NUM_PARTITIONS.toString()), record.getSimpleField(IdealState.IdealStateProperty.REBALANCE_MODE.toString()), partition, instance2, Integer.toString(i));
                        }
                    }
                    continue;
                }
                if (inputLine.indexOf("LIVEINSTANCES") != -1) {
                    pos = inputLine.indexOf("LIVEINSTANCES");
                    if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                    timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                    ZkLogCSVFormatter.formatter(liBw, timestamp, record.getId(), record.getSimpleField("SESSION_ID"), "ADD");
                    String zkSessionId = ZkLogCSVFormatter.getAttributeValue(inputLine, "session:");
                    if (zkSessionId == null) {
                        System.err.println("no zk session id associated with the adding of live instance: " + inputLine);
                        continue;
                    }
                    liveInstanceSessionMap.put(zkSessionId, record);
                    continue;
                }
                if (inputLine.indexOf("EXTERNALVIEW") != -1) {
                    pos = inputLine.indexOf("EXTERNALVIEW");
                    if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                    timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                    for (String partition : record.getMapFields().keySet()) {
                        stateMap = record.getMapFields().get(partition);
                        for (String instance2 : stateMap.keySet()) {
                            String state = stateMap.get(instance2);
                            ZkLogCSVFormatter.formatter(evBw, timestamp, record.getId(), partition, instance2, state);
                        }
                    }
                    continue;
                }
                if (inputLine.indexOf("STATEMODELDEFS") != -1) {
                    pos = inputLine.indexOf("STATEMODELDEFS");
                    if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                    timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                    for (String stateInfo : record.getMapFields().keySet()) {
                        if (stateInfo.endsWith(".meta")) {
                            Map<String, String> metaMap = record.getMapFields().get(stateInfo);
                            ZkLogCSVFormatter.formatter(smdCntBw, timestamp, record.getId(), stateInfo.substring(0, stateInfo.indexOf(46)), metaMap.get("count"));
                            continue;
                        }
                        if (!stateInfo.endsWith(".next")) continue;
                        Map<String, String> nextMap = record.getMapFields().get(stateInfo);
                        for (String destState : nextMap.keySet()) {
                            ZkLogCSVFormatter.formatter(smdNextBw, timestamp, record.getId(), stateInfo.substring(0, stateInfo.indexOf(46)), destState, nextMap.get(destState));
                        }
                    }
                    continue;
                }
                if (inputLine.indexOf("CURRENTSTATES") != -1) {
                    pos = inputLine.indexOf("CURRENTSTATES");
                    if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                    timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                    for (String partition : record.getMapFields().keySet()) {
                        stateMap = record.getMapFields().get(partition);
                        String path = ZkLogCSVFormatter.getAttributeValue(inputLine, "path:");
                        if (path == null) continue;
                        instance2 = HelixUtil.getInstanceNameFromPath(path);
                        ZkLogCSVFormatter.formatter(csBw, timestamp, record.getId(), partition, instance2, record.getSimpleField("SESSION_ID"), stateMap.get("CURRENT_STATE"));
                    }
                    continue;
                }
                if (inputLine.indexOf("MESSAGES") != -1) {
                    pos = inputLine.indexOf("MESSAGES");
                    if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                    timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                    ZkLogCSVFormatter.formatter(msgBw, timestamp, record.getSimpleField("RESOURCE_NAME"), record.getSimpleField("PARTITION_NAME"), record.getSimpleField("TGT_NAME"), record.getSimpleField("TGT_SESSION_ID"), record.getSimpleField("FROM_STATE"), record.getSimpleField("TO_STATE"), record.getSimpleField("MSG_TYPE"), record.getSimpleField("MSG_STATE"));
                    continue;
                }
                if (inputLine.indexOf("closeSession") != -1) {
                    String zkSessionId = ZkLogCSVFormatter.getAttributeValue(inputLine, "session:");
                    if (zkSessionId == null) {
                        System.err.println("no zk session id associated with the closing of zk session: " + inputLine);
                        continue;
                    }
                    record = (ZNRecord)liveInstanceSessionMap.remove(zkSessionId);
                    if (record == null) continue;
                    String timestamp2 = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                    ZkLogCSVFormatter.formatter(liBw, timestamp2, record.getId(), record.getSimpleField("SESSION_ID"), "DELETE");
                    continue;
                }
                if (inputLine.indexOf("HEALTHREPORT/defaultPerfCounters") == -1) continue;
                pos = inputLine.indexOf("HEALTHREPORT/defaultPerfCounters");
                if ((pos = inputLine.indexOf("data:{", pos)) == -1) continue;
                timestamp = ZkLogCSVFormatter.getAttributeValue(inputLine, "time:");
                record = (ZNRecord)_deserializer.deserialize(inputLine.substring(pos + 5).getBytes());
                String path = ZkLogCSVFormatter.getAttributeValue(inputLine, "path:");
                if (path == null) continue;
                String instance3 = HelixUtil.getInstanceNameFromPath(path);
                ZkLogCSVFormatter.formatter(hrPerfBw, timestamp, instance3, record.getSimpleField("availableCPUs"), record.getSimpleField("averageSystemLoad"), record.getSimpleField("freeJvmMemory"), record.getSimpleField("freePhysicalMemory"), record.getSimpleField("totalJvmMemory"));
            }
            br.close();
            isBw.close();
            cfgBw.close();
            evBw.close();
            smdCntBw.close();
            smdNextBw.close();
            csBw.close();
            msgBw.close();
            liBw.close();
            hrPerfBw.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

