/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.JMException;
import org.apache.helix.HelixManager;
import org.apache.helix.monitoring.mbeans.ThreadPoolExecutorMonitor;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.task.TaskFactory;
import org.apache.helix.task.TaskStateModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStateModelFactory
extends StateModelFactory<TaskStateModel> {
    private static Logger LOG = LoggerFactory.getLogger(TaskStateModelFactory.class);
    private final HelixManager _manager;
    private final Map<String, TaskFactory> _taskFactoryRegistry;
    private final ScheduledExecutorService _taskExecutor;
    private final ScheduledExecutorService _timerTaskExecutor;
    private ThreadPoolExecutorMonitor _monitor;
    public static final int TASK_THREADPOOL_SIZE = 40;

    public TaskStateModelFactory(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry) {
        this(manager, taskFactoryRegistry, Executors.newScheduledThreadPool(40, new ThreadFactory(){
            private AtomicInteger threadId = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TaskStateModelFactory-task_thread-" + this.threadId.getAndIncrement());
            }
        }));
    }

    public TaskStateModelFactory(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry, ScheduledExecutorService taskExecutor) {
        this._manager = manager;
        this._taskFactoryRegistry = taskFactoryRegistry;
        this._taskExecutor = taskExecutor;
        this._timerTaskExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TaskStateModelFactory-timeTask_thread");
            }
        });
        if (this._taskExecutor instanceof ThreadPoolExecutor) {
            try {
                this._monitor = new ThreadPoolExecutorMonitor("Task", (ThreadPoolExecutor)((Object)this._taskExecutor));
            }
            catch (JMException e) {
                LOG.warn("Error in creating ThreadPoolExecutorMonitor for TaskStateModelFactory.");
            }
        }
    }

    @Override
    public TaskStateModel createNewStateModel(String resourceName, String partitionKey) {
        return new TaskStateModel(this._manager, this._taskFactoryRegistry, this._taskExecutor, this._timerTaskExecutor);
    }

    public void shutdown() {
        if (this._monitor != null) {
            this._monitor.unregister();
        }
        this._taskExecutor.shutdown();
        this._timerTaskExecutor.shutdown();
        if (this._monitor != null) {
            this._monitor.unregister();
        }
    }

    public boolean isShutdown() {
        return this._taskExecutor.isShutdown();
    }

    public boolean isTerminated() {
        return this._taskExecutor.isTerminated();
    }
}

