/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.StateModelParser;
import org.apache.helix.participant.statemachine.StateTransitionError;
import org.apache.helix.participant.statemachine.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StateModelInfo(initialState="OFFLINE", states={"LEADER", "STANDBY"})
public abstract class AbstractHelixLeaderStandbyStateModel
extends StateModel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHelixLeaderStandbyStateModel.class);
    protected final String _zkAddr;

    public AbstractHelixLeaderStandbyStateModel(String zkAddr) {
        this._zkAddr = zkAddr;
        StateModelParser parser = new StateModelParser();
        this._currentState = parser.getInitialState(this.getClass());
    }

    @Transition(to="STANDBY", from="OFFLINE")
    public abstract void onBecomeStandbyFromOffline(Message var1, NotificationContext var2);

    @Transition(to="LEADER", from="STANDBY")
    public abstract void onBecomeLeaderFromStandby(Message var1, NotificationContext var2) throws Exception;

    @Transition(to="STANDBY", from="LEADER")
    public abstract void onBecomeStandbyFromLeader(Message var1, NotificationContext var2);

    @Transition(to="OFFLINE", from="STANDBY")
    public abstract void onBecomeOfflineFromStandby(Message var1, NotificationContext var2);

    @Transition(to="DROPPED", from="OFFLINE")
    public abstract void onBecomeDroppedFromOffline(Message var1, NotificationContext var2);

    @Transition(to="OFFLINE", from="DROPPED")
    public void onBecomeOfflineFromDropped(Message message, NotificationContext context) {
        this.reset();
        this.logStateTransition("DROPPED", "OFFLINE", message == null ? "" : message.getPartitionName(), message == null ? "" : message.getTgtName());
    }

    @Transition(to="OFFLINE", from="ERROR")
    public void onBecomeOfflineFromError(Message message, NotificationContext context) {
        this.reset();
        this.logStateTransition("ERROR", "OFFLINE", message == null ? "" : message.getPartitionName(), message == null ? "" : message.getTgtName());
    }

    @Override
    public void rollbackOnError(Message message, NotificationContext context, StateTransitionError error) {
        this.reset();
        logger.info("{} rolled back on error. Code: {}, Exception: {}", new Object[]{this.getStateModeInstanceDescription(message == null ? "" : message.getPartitionName(), message == null ? "" : message.getTgtName()), error == null ? "" : error.getCode(), error == null ? "" : error.getException()});
    }

    @Override
    public abstract void reset();

    protected String getStateModeInstanceDescription(String partitionName, String instanceName) {
        return String.format("%s(%s) for partition %s on instance %s", this.getClass().getSimpleName(), this.hashCode(), partitionName, instanceName);
    }

    protected void logStateTransition(String fromState, String toState, String partitionName, String instanceName) {
        logger.info("Helix Service {} became {} from {}.", new Object[]{this.getStateModeInstanceDescription(partitionName, instanceName), toState, fromState});
    }
}

