/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import org.apache.helix.monitoring.mbeans.WorkflowMonitorMBean;
import org.apache.helix.task.TaskState;

public class WorkflowMonitor
implements WorkflowMonitorMBean {
    private static final String WORKFLOW_KEY = "Workflow";
    private static final long DEFAULT_RESET_INTERVAL_MS = 3600000L;
    private String _clusterName;
    private String _workflowType;
    private long _successfulWorkflowCount;
    private long _failedWorkflowCount;
    private long _failedWorkflowGauge;
    private long _existingWorkflowGauge;
    private long _queuedWorkflowGauge;
    private long _runningWorkflowGauge;
    private long _totalWorkflowLatencyCount;
    private long _maximumWorkflowLatencyGauge;
    private long _lastResetTime;

    public WorkflowMonitor(String clusterName, String workflowType) {
        this._clusterName = clusterName;
        this._workflowType = workflowType;
        this._successfulWorkflowCount = 0L;
        this._failedWorkflowCount = 0L;
        this._failedWorkflowGauge = 0L;
        this._existingWorkflowGauge = 0L;
        this._queuedWorkflowGauge = 0L;
        this._runningWorkflowGauge = 0L;
        this._totalWorkflowLatencyCount = 0L;
        this._maximumWorkflowLatencyGauge = 0L;
        this._lastResetTime = System.currentTimeMillis();
    }

    @Override
    public long getSuccessfulWorkflowCount() {
        return this._successfulWorkflowCount;
    }

    @Override
    public long getFailedWorkflowCount() {
        return this._failedWorkflowCount;
    }

    @Override
    public long getFailedWorkflowGauge() {
        return this._failedWorkflowGauge;
    }

    @Override
    public long getExistingWorkflowGauge() {
        return this._existingWorkflowGauge;
    }

    @Override
    public long getQueuedWorkflowGauge() {
        return this._queuedWorkflowGauge;
    }

    @Override
    public long getRunningWorkflowGauge() {
        return this._runningWorkflowGauge;
    }

    @Override
    public long getWorkflowLatencyCount() {
        return this._totalWorkflowLatencyCount;
    }

    @Override
    public long getMaximumWorkflowLatencyGauge() {
        return this._maximumWorkflowLatencyGauge;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s", this._clusterName, WORKFLOW_KEY, this._workflowType);
    }

    public String getWorkflowType() {
        return this._workflowType;
    }

    public void updateWorkflowCounters(TaskState to) {
        this.updateWorkflowCounters(to, 0L);
    }

    public void updateWorkflowCounters(TaskState to, long latency) {
        if (to.equals((Object)TaskState.FAILED)) {
            ++this._failedWorkflowCount;
        } else if (to.equals((Object)TaskState.COMPLETED)) {
            ++this._successfulWorkflowCount;
            this._maximumWorkflowLatencyGauge = Math.max(this._maximumWorkflowLatencyGauge, latency);
            this._totalWorkflowLatencyCount += latency > 0L ? latency : 0L;
        }
    }

    public void resetGauges() {
        this._failedWorkflowGauge = 0L;
        this._existingWorkflowGauge = 0L;
        this._runningWorkflowGauge = 0L;
        this._queuedWorkflowGauge = 0L;
        if (this._lastResetTime + 3600000L < System.currentTimeMillis()) {
            this._lastResetTime = System.currentTimeMillis();
            this._maximumWorkflowLatencyGauge = 0L;
        }
    }

    public void updateWorkflowGauges(TaskState current) {
        if (current == null || current.equals((Object)TaskState.NOT_STARTED)) {
            ++this._queuedWorkflowGauge;
        } else if (current.equals((Object)TaskState.IN_PROGRESS)) {
            ++this._runningWorkflowGauge;
        } else if (current.equals((Object)TaskState.FAILED)) {
            ++this._failedWorkflowGauge;
        }
        ++this._existingWorkflowGauge;
    }
}

