/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.model.Partition;

public class PartitionStateMap {
    private Map<Partition, Map<String, String>> _stateMap;
    private String _resourceName;

    public PartitionStateMap(String resourceName) {
        this._resourceName = resourceName;
        this._stateMap = new HashMap<Partition, Map<String, String>>();
    }

    public PartitionStateMap(String resourceName, Map<Partition, Map<String, String>> partitionStateMap) {
        this._resourceName = resourceName;
        this._stateMap = partitionStateMap;
    }

    public Set<Partition> partitionSet() {
        return this._stateMap.keySet();
    }

    public void setState(Partition partition, Map<String, String> stateMappingForPartition) {
        this._stateMap.put(partition, stateMappingForPartition);
    }

    public void setState(Partition partition, String instance, String state) {
        if (!this._stateMap.containsKey(partition)) {
            this._stateMap.put(partition, new HashMap());
        }
        this._stateMap.get(partition).put(instance, state);
    }

    public Map<String, String> getPartitionMap(Partition partition) {
        Map<String, String> map = this._stateMap.get(partition);
        return map != null ? map : Collections.emptyMap();
    }

    public Map<Partition, Map<String, String>> getStateMap() {
        return this._stateMap;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public String toString() {
        return this._stateMap.toString();
    }
}

